package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.figures.TextArea;
import net.sf.amateras.air.mxml.models.NumericStepperModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link NumericStepperModel}.
 * @author ogawahideko
 *
 */
public class NumericStepperEditPart extends AbstractDirectEditPart {

	@Override
	protected IFigure createFigure() {
		TextArea figure = new TextArea();
		figure.getTextFigure().setLabelAlignment(Label.RIGHT);
		updateFigure((NumericStepperModel) getModel(), figure);
		return figure;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		NumericStepperModel model = (NumericStepperModel) getModel();
		TextArea figure = (TextArea) getFigure();

		updateFigure(model, figure);
	}

	protected void updateFigure(NumericStepperModel model, TextArea figure) {
		figure.setToolTip(new Label(model.toString()));
		figure.setText(model.getAttributeToString(NumericStepperModel.VALUE));
		figure.revalidate();
	}

	@Override
	protected String getDirectEditPropertyKey() {
		return NumericStepperModel.VALUE;
	}

	@Override
	protected IFigure getDirectEditFigure() {
		return ((TextArea) getFigure()).getTextFigure();
	}

}
