package net.sf.amateras.air.mxml.editparts;

import java.util.List;

import net.sf.amateras.air.mxml.editparts.policy.ResizeableFlowLayoutEditPolicy;
import net.sf.amateras.air.mxml.editparts.policy.RootEditPolicy;
import net.sf.amateras.air.mxml.figures.PanelFigure;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.PanelModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.RGB;

/**
 * The editpart for the {@link PanelModel}.
 * 
 * @author ogawahideko
 *
 */
public class PanelEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		PanelFigure figure = new PanelFigure();
		updateFigure(figure, (PanelModel) getModel());
		return figure;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		PanelModel model = (PanelModel) getModel();
		PanelFigure figure = (PanelFigure) getFigure();
		updateFigure(figure, model);
	}

	protected void updateFigure(PanelFigure panel, PanelModel model) {
		panel.setToolTip(new Label(model.toString()));
		panel.setBorderColor(getColor((RGB) model.getAttribute(PanelModel.BORDER_COLOR)));
		panel.setTitleColor(getColor((RGB) model.getAttribute(PanelModel.COLOR)));
		panel.setTitle(model.getAttributeToString(PanelModel.TITLE));
		panel.setBackgroundColor(getColor((RGB) model.getAttribute(PanelModel.BACKGROUND_COLOR)));

		String direction = (String) model.getAttribute(PanelModel.LAYOUT);
		if (direction.equalsIgnoreCase("vertical")) {
			panel.setLayout(false);
			panel.setVertical(true);
			try {
				panel.setSpacing(model.getAttributeToNumber(PanelModel.VERTICAL_GAP));
			} catch (NumberFormatException e) {
				//Nothing todo.
			}
			installEditPolicy(EditPolicy.LAYOUT_ROLE, new ResizeableFlowLayoutEditPolicy());

		} else if (direction.equalsIgnoreCase("horizontal")) {
			panel.setLayout(false);
			panel.setVertical(false);
			try {
				panel.setSpacing(model.getAttributeToNumber(PanelModel.HORIZONTAL_GAP));
			} catch (NumberFormatException e) {
				//Nothing todo.
			}
			installEditPolicy(EditPolicy.LAYOUT_ROLE, new ResizeableFlowLayoutEditPolicy());

		} else {
			panel.setLayout(true);
			installEditPolicy(EditPolicy.LAYOUT_ROLE, new RootEditPolicy());

		}

		try {
			int top = model.getAttributeToNumber(PanelModel.PADDING_TOP);
			int left = model.getAttributeToNumber(PanelModel.PADDING_LEFT);
			int right = model.getAttributeToNumber(PanelModel.PADDING_RIGHT);
			int bottom = model.getAttributeToNumber(PanelModel.PADDING_BOTTOM);
			panel.setPadding(new Insets(top, left, bottom, right));
		} catch (NumberFormatException e) {
			//Nothing todo.
		}

		panel.revalidate();
	}

	@Override
	protected List<IComponentModel> getModelChildren() {
		return ((IContainerModel) getModel()).getChildren();
	}

}
