package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.ComboBox;
import net.sf.amateras.air.mxml.models.PopUpButtonModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link PopUpButtonModel}.
 * 
 * @author ogawahideko
 */
public class PopUpButtonEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		ComboBox comboBox = new ComboBox();
		updateFigure(comboBox, (PopUpButtonModel) getModel());
		return comboBox;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((ComboBox) getFigure(), (PopUpButtonModel) getModel());
	}

	private void updateFigure(ComboBox comboBox, PopUpButtonModel model) {
		comboBox.setToolTip(new Label(model.toString()));
		AIRPlugin.getDefault().getFontManager().setFont(model, comboBox);

		if (model.getAttribute(PopUpButtonModel.COLOR) != null) {
			comboBox.setForegroundColor(getColor(PopUpButtonModel.COLOR));
		}
	}

}
