package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.ProgressBarFigure;
import net.sf.amateras.air.mxml.models.ProgressBarModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link ProgressBarModel}.
 * @author ogawahideko
 *
 */
public class ProgressBarEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		ProgressBarFigure figure = new ProgressBarFigure();
		updateFigure((ProgressBarModel) getModel(), figure);
		return figure;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		ProgressBarModel model = (ProgressBarModel) getModel();
		ProgressBarFigure figure = (ProgressBarFigure) getFigure();

		updateFigure(model, figure);
	}

	protected void updateFigure(ProgressBarModel model, ProgressBarFigure figure) {
		figure.setToolTip(new Label(model.toString()));
		AIRPlugin.getDefault().getFontManager().setFont(model, figure);
		figure.setTextVAlign(model.getAttributeToString(ProgressBarModel.LABEL_PLACEMENT));
		figure.revalidate();
	}

}
