package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.figures.BoxFigure;
import net.sf.amateras.air.mxml.models.SliderBaseModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link SliderBaseModel}.
 * @author ogawahideko
 *
 */
public class SliderEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		BoxFigure figure = new BoxFigure();
		updateFigure((SliderBaseModel) getModel(), figure);
		return figure;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		SliderBaseModel model = (SliderBaseModel) getModel();
		BoxFigure figure = (BoxFigure) getFigure();

		updateFigure(model, figure);
	}

	protected void updateFigure(SliderBaseModel model, BoxFigure figure) {
		figure.setToolTip(new Label(model.toString()));
		figure.revalidate();
	}

}
