package net.sf.amateras.air.mxml.editparts;

import java.beans.PropertyChangeEvent;
import java.util.List;

import net.sf.amateras.air.mxml.editparts.policy.RootEditPolicy;
import net.sf.amateras.air.mxml.figures.RootFigure;
import net.sf.amateras.air.mxml.models.ApplicationModel;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.WindowModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

/**
 * The editpart for the {@link WindowModel}
 * 
 * @author ogawahideko
 */
public class WindowEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		RootFigure figure = new RootFigure();
		updateFigure(figure);
		return figure;
	}

	@Override
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new RootEditPolicy());
	}

	@Override
	protected List<IComponentModel> getModelChildren() {
		return ((IContainerModel) getModel()).getChildren();
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		refreshVisuals();
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((RootFigure) getFigure());
		for (int i = 0; i < getModelChildren().size(); i++) {
			getModelChildren().get(i).fireChildPropertyChange();
		}
		refreshChildren();
	}

	protected void updateFigure(RootFigure figure) {
		WindowModel model = (WindowModel) getModel();
		setDefaultSize(figure);
		figure.setBackgroundColor(getColor((RGB) model.getAttribute(ApplicationModel.BACKGROUND_COLOR)));
	}

	protected void setDefaultSize(RootFigure figure) {
		if (getViewer() != null && getViewer().getControl() != null) {
			Rectangle bounds = getViewer().getControl().getBounds();
			figure.setDefaultWidth(bounds.width - 1);
			figure.setDefaultHeight(bounds.height - 1);
		}
	}

}
