package net.sf.amateras.air.mxml.figures;

import net.sf.amateras.air.mxml.figures.layouts.ToolbarAbsoluteLayout;
import net.sf.amateras.air.mxml.figures.layouts.XYAbsoluteLayout;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;

/**
 * Container Figure.
 * can change ToolbarLayout , XYLayout
 * @author ogawahideko
 *
 */
public class ContainerFigure extends AbstractFigure {

	private ToolbarLayout toolBarLayout;
	private XYAbsoluteLayout xyLayout;

	private static final Insets BLANK_INSETS = new Insets(0, 0, 0, 0);
	private LinedMarginBorder border;

	public ContainerFigure() {
		toolBarLayout = new ToolbarAbsoluteLayout();
		border = new LinedMarginBorder(BLANK_INSETS, 1, ColorConstants.lightGray);
		setBorder(border);
	}

	public void setPadding(Insets insets) {
		border.setPaddingInsets(insets);
	}

	public void setLayout(boolean isXyLayout) {
		if (!isXyLayout && getLayoutManager() == toolBarLayout) {
			return;
		}
		if (isXyLayout) {
			if (xyLayout == null) {
				xyLayout = new XYAbsoluteLayout();
			}
			setLayoutManager(xyLayout);
		} else {
			setLayoutManager(toolBarLayout);
		}
	}

	public ToolbarLayout getToolbarLayout() {
		return toolBarLayout;
	}

	public void setVertical(boolean isVertical) {
		toolBarLayout.setVertical(isVertical);
	}

	public void setSpacing(int spaceing) {
		toolBarLayout.setSpacing(spaceing);
	}

	public int getDefaultWidth() {
		return -1;
	}

	public int getDefaultHeight() {
		return -1;
	}

}
