package net.sf.amateras.air.mxml.figures;

import net.sf.amateras.air.mxml.figures.layouts.SizeLibrary;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.swt.graphics.Font;

public class ProgressBarFigure extends AbstractFigure implements ColorConstants {

	private LabelFigure label;
	private Figure progress;
	private ToolbarLayout layout;

	public ProgressBarFigure() {
		layout = new ToolbarLayout();
		setLayoutManager(layout);
		layout.setStretchMinorAxis(true);
		layout.setSpacing(3);

		progress = new ProgressBar();
		progress.getBounds().height = 7;
		progress.getBounds().width = 150;

		add(progress);
		label = new LabelFigure();
		label.setText("LOADING 0%");
		label.setLabelAlignment(Label.LEFT);
		add(label);
	}

	public int getDefaultWidth() {
		if (label.getPreferredSize().width > 150) {
			return label.getPreferredSize().width;
		}
		return 150;
	}

	public int getDefaultHeight() {
		if (layout.isHorizontal()) {
			return label.getPreferredSize().height;
		} else {
			return label.getPreferredSize().height + layout.getSpacing() + 10;
		}
	}

	@Override
	public void setFont(Font font) {
		label.setFont(font);
	}

	public void setTextVAlign(String position) {
		removeAll();
		if (position.equals("top")) {
			layout.setVertical(true);
			add(label);
			add(progress);
		} else if (position.equals("bottom")) {
			layout.setVertical(true);
			add(progress);
			add(label);
		} else if (position.equals("left")) {
			layout.setVertical(false);
			add(label);
			add(progress);
		} else if (position.equals("right")) {
			layout.setVertical(false);
			add(progress);
			add(label);
		}
	}

	private int progressWidth;

	class ProgressBar extends Figure {
		@Override
		public void paint(Graphics graphics) {
			int x = getBounds().x;
			int y = getBounds().y + getBounds().height / 2 - 1;
			int height = 4;

			int width = SizeLibrary.getUseSize(ProgressBarFigure.this, -1, -1).width;
			if (layout.isHorizontal()) {
				width = width - label.getPreferredSize().width - layout.getSpacing() - 2;
			} else {
				width = ProgressBarFigure.this.getPreferredSize().width - layout.getSpacing() - 2;
			}
			if (progressWidth != width + 2) {
				progress.getBounds().width = width + 2;
				progressWidth = width + 2;
				layout.layout(ProgressBarFigure.this);
			}

			graphics.setForegroundColor(white);
			graphics.fillRectangle(x + 1, y + 1, x + width - 2, y + height - 2);
			graphics.setForegroundColor(buttonDarker);
			graphics.drawLine(x, y, x + width, y);
			graphics.drawLine(x, y + height, x + width, y + height);
			graphics.drawLine(x, y, x, y + height);
			graphics.drawLine(x + width, y, x + width, y + height);
		}
	}
}
