package net.sf.amateras.air.mxml.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ColorUtil;

/**
 * An abstract class for GUI component models.
 * 
 * implements mx.core.UIComponent.
 * 
 * @author Naoki Takezoe
 */
public abstract class AbstractComponentModel extends AbstractModel implements IComponentModel {

	protected static final String[] LIST_IME_MODE = { "", "ALPHANUMERIC_FULL", "ALPHANUMERIC_HALF", "CHINESE",
			"JAPANESE_HIRAGANA", "JAPANESE_KATAKANA_FULL", "JAPANESE_KATAKANA_HALF", "KOREAN" };

	protected static final String[] LIST_BORDER_STYLE = { "none", "solid", "inset", "outset" };

	protected static final String[] LIST_FONT_STYLE = { "normal", "italic" };

	protected static final String[] LIST_FONT_WEIGHT = { "normal", "bold" };

	protected static final String[] LIST_LEFT_RIGHT_CENTER = { "left", "right", "center" };

	protected static final String[] LIST_FONT_ALIAS_TYPE = { "advanced", "normal" };

	protected static final String[] LIST_GRID_FIT_TYPE = { "pixel", "none", "subpixel" };

	protected static final String[] LIST_TEXT_DECORATION = { "none", "underline" };

	protected static final String[] LIST_LABEL_PLACEMENT = { "right", "left", "bottom", "top" };

	protected static final String[] LIST_BUTTON_ALIGNMENT = { "left", "right", "auto" };

	protected static final String[] LIST_TITLE_ALIGNMENT = { "left", "center", "auto" };

	protected static final String[] LIST_SYSTEM_CHROME = { "none", "standard" };

	protected static final String[] LIST_WINDOW_TYPE = { "lightweight", "normal", "utility" };

	protected static final String[] LIST_THEME_COLOR = { "haloBlue", "haloGreen", "haloOrange" };
	// properties
	public static final String ALPHA = "alpha";
	public static final String AUTOMATION_DELEGATE = "automationDelegate";
	public static final String AUTOMATION_NAME = "automationName";
	public static final String BLEND_MODE = "blendMode";
	public static final String BUTTON_MODE = "buttonMode";
	public static final String CACHE_AS_BITMAP = "cacheAsBitmap";
	public static final String CACHE_HUEURISTIC = "cacheHeuristic";
	public static final String CACHE_POLICY = "cachePolicy";
	public static final String CURRENT_STATE = "currentState";
	public static final String DOUBLE_CLICK_ENABLED = "doubleClickEnabled";
	public static final String ENABLED = "enabled";
	public static final String ERROR_STRING = "errorString";
	public static final String EXPLICIT_HIGHT = "explicitHeight";
	public static final String EXPLICIT_MAX_HEIGHT = "explicitMaxHeight";
	public static final String EXPLICIT_MAX_WIDTH = "explicitMaxWidth";
	public static final String EXPLICT_MIN_HEIGHT = "explicitMinHeight";
	public static final String EXPLICT_MIN_WIDTH = "explicitMinWidth";
	public static final String EXPLICT_WIDTH = "explicitWidth";
	public static final String FOCUS_ENABLED = "focusEnabled";
	//	public static final String HEIGHT = "height";
	//	public static final String ID = "id";
	public static final String INCLUDE_IN_LAYOUT = "includeInLayout";
	public static final String MAX_HEIGHT = "maxHeight";
	public static final String MAX_WIDTH = "maxWidth";
	public static final String MEASUERD_HEIGHT = "measuredHeight";
	public static final String MEASURED_MIN_HEIGHT = "measuredMinHeight";
	public static final String MEASURED_MIN_WIDTH = "measuredMinWidth";
	public static final String MEASURED_WIDTH = "measuredWidth";
	public static final String MIN_HEIGHT = "minHeight";
	public static final String MIN_WIDTH = "minWidth";

	public static final String MOUSE_CHILDREN = "mouseChildren";
	public static final String MOUSE_ENABLED = "mouseEnabled";
	public static final String MOUSE_FOCUS_ENABLED = "mouseFocusEnabled";

	public static final String NAME = "name";
	public static final String NEST_LEVEL = "nestLevel";

	public static final String PERCENT_HEIGHT = "percentHeight";
	public static final String PERCENT_WIDTH = "percentWidth";

	public static final String ROTATION = "rotation";
	public static final String ROTATION_X = "rotationX";
	public static final String ROTATION_Y = "rotationY";
	public static final String ROTATION_Z = "rotationZ";

	public static final String SCALE_X = "scaleX";
	public static final String SCALE_Y = "scaleY";
	public static final String SCALE_Z = "scaleZ";

	public static final String SHOW_IN_AUTOMATION_HIERARCHY = "showInAutomationHierarchy";
	public static final String STATES = "states";
	public static final String STYLE_NAME = "styleName";

	public static final String TAB_CHILDREN = "tabChildren";
	public static final String TAB_ENALBED = "tabEnabled";
	public static final String TAB_INDEX = "tabIndex";

	public static final String TOOL_TIP = "toolTip";
	public static final String UID = "uid";
	public static final String USE_HAND_CURSOR = "useHandCursor";
	public static final String VALIDATION_SUB_FIELD = "validationSubField";
	public static final String VISIBLE = "visible";
	//	public static final String WIDTH = "width";
	//	public static final String X = "x";
	//	public static final String Y = "y";
	public static final String Z = "z";

	//styles
	public static final String BASE_LINE = "baseline";
	public static final String BOTTOM = "bottom";
	public static final String ERROR_COLOR = "errorColor";
	public static final String FOCUS_BLEND_MODE = "focusBlendMode";
	public static final String FOCUS_SKIN = "focusSkin";
	public static final String FOCUS_THICKNESS = "focusThickness";
	public static final String HORIZONTAL_CENTER = "horizontalCenter";
	public static final String LEFT = "left";
	public static final String RIGHT = "right";
	public static final String THEME_COLOR = "themeColor";
	public static final String TOP = "top";
	public static final String VERTICAL_CENTER = "verticalCenter";

	//effects
	public static final String ADDED_EFFECT = "addedEffect";
	public static final String CREATION_COMPLETE_EFFECT = "creationCompleteEffect";
	public static final String FOCUS_IN_EFFECT = "focusInEffect";
	public static final String FOCUS_OUT_EFFECT = "focusOutEffect";
	public static final String HIDE_EFFECT = "hideEffect";
	public static final String MOUSE_DOWN_EFFECT = "mouseDownEffect";
	public static final String MOUSE_UP_EFFECT = "mouseUpEffect";
	public static final String MOVE_EFFECT = "moveEffect";
	public static final String REMOVED_EFFECT = "removedEffect";
	public static final String RESIZE_EFFECT = "resizeEffect";
	public static final String ROLL_OUT_EFFECT = "rollOutEffect";
	public static final String ROLL_OVER_EFFECT = "rollOverEffect";
	public static final String SHOW_EFFECT = "showEffect";

	//Events
	public static final String ACTIVATE = "activate";
	public static final String ADD = "add";
	public static final String ADDED = "added";
	public static final String ADDED_TO_STAGE = "addedToStage";
	public static final String CLEAR = "clear";
	public static final String CLICK = "click";
	public static final String CONTEXT_MENU = "contextMenu";
	public static final String COPY = "copy";
	public static final String CREATION_COMPLETE = "creationComplete";
	public static final String CURRENT_STATE_CHANGE = "currentStateChange";
	public static final String CURRENT_STATE_CHANGING = "currentStateChanging";
	public static final String CUT = "cut";
	public static final String DEACTIVATE = "deactivate";
	public static final String DOUBLE_CLICK = "doubleClick";

	public static final String DRAG_COMPLETE = "dragComplete";
	public static final String DRAG_DROP = "dragDrop";
	public static final String DRAG_ENTER = "dragEnter";
	public static final String DRAG_EXIT = "dragExit";
	public static final String DRAG_OVER = "dragOver";
	public static final String DRAG_START = "dragStart";
	public static final String EFFECT_END = "effectEnd";
	public static final String EFFECT_START = "effectStart";
	public static final String ENTER_FRAME = "enterFrame";
	public static final String ENTER_STATE = "enterState";
	public static final String EXIT_FRAME = "exitFrame";
	public static final String EXIT_STATE = "exitState";
	public static final String FOCUS_IN = "focusIn";
	public static final String FOCUS_OUT = "focusOut";
	public static final String FRAME_CONSTRUCTED = "frameConstructed";
	public static final String HIDE = "hide";
	public static final String INITIALIZE = "initialize";
	public static final String INVALID = "invalid";
	public static final String KEY_DOWN = "keyDown";
	public static final String KEY_FOCUS_CHANGE = "keyFocusChange";
	public static final String KEY_UP = "keyUp";
	public static final String MIDDLE_CLICK = "middleClick";
	public static final String MIDDLE_MOUSE_DOWN = "middleMouseDown";
	public static final String MIDDLE_MOUSE_UP = "middleMouseUp";
	public static final String MOUSE_DOWN = "mouseDown";
	public static final String MOUSE_DOWN_OUTSIDE = "mouseDownOutside";
	public static final String MOUSE_FOCUS_CHANGE = "mouseFocusChange";
	public static final String MOUSE_MOVE = "mouseMove";
	public static final String MOUSE_OUT = "mouseOut";
	public static final String MOUSE_OVER = "mouseOver";
	public static final String MOUSE_UP = "mouseUp";
	public static final String MOUSE_WHEEL = "mouseWheel";
	public static final String MOUSE_WHEEL_OUTSIDE = "mouseWheelOutside";
	public static final String MOVE = "move";
	public static final String NATIVE_DRAG_COMPLETE = "nativeDragComplete";
	public static final String NATIVE_DRAG_DROP = "nativeDragDrop";
	public static final String NATIVE_DRAG_ENTER = "nativeDragEnter";
	public static final String NATIVE_DRAG_EXIT = "nativeDragExit";
	public static final String NATIVE_DRAG_OVER = "nativeDragOver";
	public static final String NATIVE_DRAG_START = "nativeDragStart";
	public static final String NATIVE_DRAG_UPDATE = "nativeDragUpdate";
	public static final String PASTE = "paste";
	public static final String PREINITIALIZE = "preinitialize";
	public static final String REMOVE = "remove";
	public static final String REMOVED = "removed";
	public static final String REMOVED_FROM_STAGE = "removedFromStage";
	public static final String RENDER = "render";
	public static final String RESIZE = "resize";
	public static final String RIGHT_CLICK = "rightClick";
	public static final String RIGHT_MOUSE_DOWN = "rightMouseDown";
	public static final String RIGHT_MOUSE_UP = "rightMouseUp";
	public static final String ROLL_OUT = "rollOut";
	public static final String ROLL_OVER = "rollOver";
	public static final String SELECT_ALL = "selectAll";
	public static final String SHOW = "show";
	public static final String TAB_CHILDREN_CHANGE = "tabChildrenChange";
	public static final String TAB_ENABLED_CHANGE = "tabEnabledChange";
	public static final String TAB_INDEX_CHANGE = "tabIndexChange";
	public static final String TOOL_TIP_CREATE = "toolTipCreate";
	public static final String TOOL_TIP_END = "toolTipEnd";
	public static final String TOOL_TIP_HIDE = "toolTipHide";
	public static final String TOOL_TIP_SHOW = "toolTipShow";
	public static final String TOOL_TIP_SHOWN = "toolTipShown";
	public static final String TOOL_TIP_START = "toolTipStart";
	public static final String UPDATE_COMPLETE = "updateComplete";
	public static final String VALID = "valid";
	public static final String VALUE_COMMIT = "valueCommit";

	public static final String CONSTRAINT = "constraint";

	protected FlexRectangle constraint;
	private IContainerModel root;

	private ArrayList<IComponentModel> children = new ArrayList<IComponentModel>();

	public AbstractComponentModel() {

	}

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addDoubleModelProperty(ALPHA, CATEGORY_COMMON_PROPERTY, null);
		addStringModelProperty(AUTOMATION_DELEGATE, CATEGORY_COMMON_PROPERTY).setAdvanced(true);
		addStringModelProperty(AUTOMATION_NAME, CATEGORY_COMMON_PROPERTY, null).setAdvanced(true);
		addListModelProperty(
				BLEND_MODE,
				CATEGORY_COMMON_PROPERTY,
				new String[] { "{BlendMode.NORMAL}", "{BlendMode.LAYER}", "{BlendMode.MULTIPLY}", "{BlendMode.SCREEN}",
						"{BlendMode.LIGHTEN}", "{BlendMode.DARKEN}", "{BlendMode.DIFFERENCE}", "{BlendMode.ADD}",
						"{BlendMode.SUBTRACT}", "{BlendMode.INVERT}", "{BlendMode.ALPHA}", "{BlendMode.ERASE}",
						"{BlendMode.OVERLAY}", "{BlendMode.HARDLIGHT}", "{BlendMode.SHADER}" }).setAdvanced(true);

		addBooleanModelProperty(BUTTON_MODE, CATEGORY_COMMON_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(CACHE_AS_BITMAP, CATEGORY_COMMON_PROPERTY).setAdvanced(true);
		addListModelProperty(CACHE_POLICY, CATEGORY_PROPERTY, new String[] { "auto", "on", "off" }).setAdvanced(true);
		addStringModelProperty(CURRENT_STATE, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(DOUBLE_CLICK_ENABLED, CATEGORY_COMMON_PROPERTY, false);
		addBooleanModelProperty(ENABLED, CATEGORY_COMMON_PROPERTY, true);
		addStringModelProperty(ERROR_STRING, CATEGORY_COMMON_PROPERTY);
		addNumberModelProperty(EXPLICIT_HIGHT, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(EXPLICIT_MAX_HEIGHT, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(EXPLICIT_MAX_WIDTH, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(EXPLICT_MIN_HEIGHT, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(EXPLICT_MIN_WIDTH, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(EXPLICT_WIDTH, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(FOCUS_ENABLED, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(INCLUDE_IN_LAYOUT, CATEGORY_PROPERTY, true).setAdvanced(true);
		addNumberModelProperty(MAX_HEIGHT, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(MAX_WIDTH, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(MEASUERD_HEIGHT, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(MEASURED_MIN_HEIGHT, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(MEASURED_MIN_WIDTH, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(MEASURED_WIDTH, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(MIN_HEIGHT, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(MIN_WIDTH, CATEGORY_PROPERTY).setAdvanced(true);

		addBooleanModelProperty(MOUSE_CHILDREN, CATEGORY_COMMON_PROPERTY, true).setAdvanced(true);
		addBooleanModelProperty(MOUSE_ENABLED, CATEGORY_COMMON_PROPERTY, true).setAdvanced(true);
		addBooleanModelProperty(MOUSE_FOCUS_ENABLED, CATEGORY_PROPERTY, true).setAdvanced(true);

		addStringModelProperty(NAME, CATEGORY_COMMON_PROPERTY).setAdvanced(true);
		addNumberModelProperty(NEST_LEVEL, CATEGORY_PROPERTY, 0).setAdvanced(true);

		addNumberModelProperty(PERCENT_HEIGHT, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(PERCENT_WIDTH, CATEGORY_PROPERTY).setAdvanced(true);

		addNumberModelProperty(ROTATION, CATEGORY_COMMON_PROPERTY).setAdvanced(true);
		addNumberModelProperty(ROTATION_X, CATEGORY_COMMON_PROPERTY).setAdvanced(true);
		addNumberModelProperty(ROTATION_Y, CATEGORY_COMMON_PROPERTY).setAdvanced(true);
		addNumberModelProperty(ROTATION_Z, CATEGORY_COMMON_PROPERTY).setAdvanced(true);

		addDoubleModelProperty(SCALE_X, CATEGORY_PROPERTY, 1.0).setAdvanced(true);
		addDoubleModelProperty(SCALE_Y, CATEGORY_PROPERTY, 1.0).setAdvanced(true);
		addDoubleModelProperty(SCALE_Z, CATEGORY_COMMON_PROPERTY, 0.0).setAdvanced(true);

		addBooleanModelProperty(SHOW_IN_AUTOMATION_HIERARCHY, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(STATES, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(STYLE_NAME, CATEGORY_PROPERTY).setAdvanced(true);

		addBooleanModelProperty(TAB_CHILDREN, CATEGORY_COMMON_PROPERTY, true).setAdvanced(true);
		addBooleanModelProperty(TAB_ENALBED, CATEGORY_COMMON_PROPERTY, true).setAdvanced(true);
		addNumberModelProperty(TAB_INDEX, CATEGORY_COMMON_PROPERTY, -1).setAdvanced(true);

		addStringModelProperty(TOOL_TIP, CATEGORY_PROPERTY);
		addStringModelProperty(UID, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(USE_HAND_CURSOR, CATEGORY_COMMON_PROPERTY, true).setAdvanced(true);
		addStringModelProperty(VALIDATION_SUB_FIELD, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(VISIBLE, CATEGORY_COMMON_PROPERTY, true);
		addNumberModelProperty(Z, CATEGORY_COMMON_PROPERTY).setAdvanced(true);

		//styles
		addStringModelProperty(BASE_LINE, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(BOTTOM, CATEGORY_STYLE).setAdvanced(true);
		addColorModelProperty(ERROR_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#FF0000")).setAdvanced(true);
		addStringModelProperty(FOCUS_BLEND_MODE, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(FOCUS_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addNumberModelProperty(FOCUS_THICKNESS, CATEGORY_STYLE, 2).setAdvanced(true);
		addStringModelProperty(HORIZONTAL_CENTER, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(LEFT, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(RIGHT, CATEGORY_STYLE).setAdvanced(true);
		addListModelProperty(THEME_COLOR, CATEGORY_COMMON_STYLE,
				new String[] { "haloBlue", "haloGreen", "haloOrange", "haloSilver" }).setAdvanced(true);
		addStringModelProperty(TOP, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(VERTICAL_CENTER, CATEGORY_STYLE).setAdvanced(true);

		//effects
		addStringModelProperty(ADDED_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(CREATION_COMPLETE_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(FOCUS_IN_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(FOCUS_OUT_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(HIDE_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(MOUSE_DOWN_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(MOUSE_UP_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(MOVE_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(REMOVED_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(RESIZE_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(ROLL_OUT_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(ROLL_OVER_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(SHOW_EFFECT, CATEGORY_EFFECT).setAdvanced(true);

		//events
		addStringModelProperty(ACTIVATE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(ADD, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(ADDED, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(ADDED_TO_STAGE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(CLEAR, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(CLICK, CATEGORY_COMMON_EVENT);
		addStringModelProperty(CONTEXT_MENU, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(COPY, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(CREATION_COMPLETE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(CURRENT_STATE_CHANGE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(CURRENT_STATE_CHANGING, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(CUT, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(DEACTIVATE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(DOUBLE_CLICK, CATEGORY_COMMON_EVENT).setAdvanced(true);

		addStringModelProperty(DRAG_COMPLETE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(DRAG_DROP, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(DRAG_ENTER, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(DRAG_EXIT, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(DRAG_OVER, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(DRAG_START, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(EFFECT_END, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(EFFECT_START, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(ENTER_FRAME, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(ENTER_STATE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(ENTER_FRAME, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(EXIT_FRAME, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(EXIT_STATE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(FOCUS_IN, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(FOCUS_OUT, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(FRAME_CONSTRUCTED, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(HIDE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(INITIALIZE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(INVALID, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(KEY_DOWN, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(KEY_FOCUS_CHANGE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(KEY_UP, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(MIDDLE_CLICK, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(MIDDLE_MOUSE_DOWN, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(MIDDLE_MOUSE_UP, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(MOUSE_DOWN, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(MOUSE_DOWN_OUTSIDE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(MOUSE_FOCUS_CHANGE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(MOUSE_MOVE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(MOUSE_OUT, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(MOUSE_OVER, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(MOUSE_UP, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(MOUSE_WHEEL, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(MOUSE_WHEEL_OUTSIDE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(MOVE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_COMPLETE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_DROP, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_ENTER, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_EXIT, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_OVER, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_START, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_UPDATE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(PASTE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(PREINITIALIZE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(REMOVE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(REMOVED, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(REMOVED_FROM_STAGE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(RENDER, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(RESIZE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(RIGHT_CLICK, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(RIGHT_MOUSE_DOWN, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(RIGHT_MOUSE_UP, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(ROLL_OUT, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(ROLL_OVER, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(SELECT_ALL, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(SHOW, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(TAB_CHILDREN_CHANGE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(TAB_ENABLED_CHANGE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(TAB_INDEX_CHANGE, CATEGORY_COMMON_EVENT).setAdvanced(true);
		addStringModelProperty(TOOL_TIP_CREATE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(TOOL_TIP_END, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(TOOL_TIP_HIDE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(TOOL_TIP_SHOW, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(TOOL_TIP_SHOWN, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(TOOL_TIP_START, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(UPDATE_COMPLETE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(VALID, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(VALUE_COMMIT, CATEGORY_EVENT).setAdvanced(true);

		addWidthHeightModelProperty(X, CATEGORY_LAYOUT, "");
		addWidthHeightModelProperty(Y, CATEGORY_LAYOUT, "");
		addWidthHeightModelProperty(WIDTH, CATEGORY_LAYOUT, "");
		addWidthHeightModelProperty(HEIGHT, CATEGORY_LAYOUT, "");

	}

	public void fireChildPropertyChange() {
		firePropertyChange(AbstractContainerModel.KEY_CHILDREN, null, null);
	}

	public void moveDown() {
		IContainerModel model = getRoot();
		int index = model.getChildIndex(this);
		model.getChildren().remove(this);
		model.getChildren().add(index + 1, this);
		model.fireChildPropertyChange();
	}

	public boolean isMoveDownEnabled() {
		IContainerModel model = getRoot();
		int index = model.getChildIndex(this) + 1;
		return (index < model.getChildren().size()) ? true : false;
	}

	public void moveUp() {
		IContainerModel model = getRoot();
		int index = model.getChildIndex(this);
		model.getChildren().remove(this);
		model.getChildren().add(index - 1, this);
		model.fireChildPropertyChange();
	}

	public boolean isMoveUpEnabled() {
		IContainerModel model = getRoot();
		int index = model.getChildIndex(this);
		return index == 0 ? false : true;
	}

	public void setRoot(IContainerModel root) {
		this.root = root;
	}

	public IContainerModel getRoot() {
		return root;
	}

	public FlexRectangle getConstraint() {
		return constraint;
	}

	public void setConstraint(FlexRectangle constraint) {
		this.constraint = constraint;
		setPropertyValue("_" + X, constraint.getStrX(), false);
		setPropertyValue("_" + Y, constraint.getStrY(), false);
		setPropertyValue("_" + WIDTH, constraint.getStrWidth(), false);
		setPropertyValue("_" + HEIGHT, constraint.getStrHeight(), false);
		firePropertyChange("_" + CONSTRAINT, null, constraint);
	}

	protected abstract String getComponentName();

	@Override
	public String toMXML() {
		StringBuilder sb = new StringBuilder();
		sb.append("<").append(AIRPlugin.getDefault().getNameSpacePrefix()).append(getComponentName());
		sb.append(getAttributesXML());

		//sb.append(getLocationAttributes());
		sb.append(getAdditionalAttributesXML());

		String childNodeXML = getChildAllNodeXML();
		if (childNodeXML != null && childNodeXML.length() != 0) {
			sb.append(">").append("\n");
			sb.append(childNodeXML);
			sb.append("</").append(AIRPlugin.getDefault().getNameSpacePrefix()).append(getComponentName()).append(">");
		} else {
			sb.append("/>");
		}
		return sb.toString();
	}

	protected String getChildAllNodeXML() {
		return getAdditionalChildElementsXML() + getChildrenXML();
	}

	@Override
	public String toString() {
		String str = AIRPlugin.getDefault().getNameSpacePrefix() + getComponentName();

		String id = getAttributeToString(ID);
		if (id.length() > 0) {
			str += " (id=" + id + ")";
		}
		return str;
	}

	public int getChildIndex(IComponentModel child) {
		int index = -1;
		for (IComponentModel model : children) {
			index++;
			if (model == child) {
				return index;
			}
		}
		return index;
	}

	public void addChild(IComponentModel child) {
		addChild(getChildren().size(), child);
	}

	public void addChild(int index, IComponentModel child) {
		children.add(index, child);
		fireChildPropertyChange();
	}

	public List<IComponentModel> getChildren() {
		return children;
	}

	public void removeChild(IComponentModel child) {
		boolean isRemoved = children.remove(child);
		if (isRemoved) {
			fireChildPropertyChange();
		} else {
			System.err.println("not remove child. parent=" + this + ", child=" + child);
		}
	}

	public void removeAll() {
		Iterator<IComponentModel> ite = children.iterator();
		while (ite.hasNext()) {
			Object object = ite.next();
			if (object instanceof AbstractContainerModel) {
				((AbstractContainerModel) object).removeAll();
			}
		}
		children.clear();
		fireChildPropertyChange();
	}

	// to XML
	// ----------------------------------------
	protected String getChildrenXML() {
		StringBuilder sb = new StringBuilder();
		if (children.size() != 0) {
			Iterator<IComponentModel> ite = children.iterator();
			while (ite.hasNext()) {
				sb.append(((AbstractModel) ite.next()).toMXML());
				sb.append("\n");
			}
		}
		return sb.toString();
	}

	/**
	 * Whether it is possible to add it as a child component or not?
	 * If it is AbstractComponentModel and not IDecidedParentComonent, it is OK.
	 * @param model
	 * @return
	 */
	public boolean canChildComponent(Object model) {
		return false;
	}

	public void addScript(String script) {

	}

	/**
	 * return to flex class pakage name.
	 * 
	 * @return
	 */
	public abstract String getFlexModelPackageName();

	/**
	 * return flex class name.
	 * @return
	 */
	public String getFlexClassName() {
		return getFlexModelPackageName() + "." + getComponentName();
	}
}
