package net.sf.amateras.air.mxml.models;

import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.ColorUtil;

/**
 * An abstract class for mx.core.Container models.
 * @author ogawahideko
 *
 */
public abstract class AbstractContainerModel extends AbstractViewModel implements IContainerModel {
	public static final String PACKAGE_NAME = "mx.containers";
	public static final String KEY_CHILDREN = "_children";
	public static final String KEY_SCRIPT = "_script";

	//properties
	public static final String AUTO_LAYOUT = "autoLayout";
	public static final String CLIP_CONTENT = "clipContent";
	public static final String CREATION_INDEX = "creationIndex";
	public static final String CREATION_POLICY = "creationPolicy";
	public static final String DEFAULT_BUTTON = "defaultButton";

	public static final String HORIZONTAL_LINE_SCROLL_SIZE = "horizontalLineScrollSize";
	public static final String HORIZONTAL_PAGE_SCROLL_SIZE = "horizontalPageScrollSize";
	public static final String HORIZONTAL_SCROLL_POLICY = "horizontalScrollPolicy";
	public static final String HORIZONTAL_SCROLL_POSITION = "horizontalScrollPosition";

	public static final String ICON = "icon";
	public static final String LABEL = "label";

	public static final String VERTICAL_LINE_SCROLL_SIZE = "verticalLineScrollSize";
	public static final String VERTICAL_PAGE_SCROLL_SIZE = "verticalPageScrollSize";
	public static final String VERTICAL_SCROLL_POLICY = "verticalScrollPolicy";
	public static final String VERTICAL_SCROLL_POSITION = "verticalScrollPosition";

	//Styles
	public static final String BACKGROUND_ALPHA = "backgroundAlpha";
	public static final String BACKGROUND_ATTACHMENT = "backgroundAttachment";
	public static final String BACKGROUND_COLOR = "backgroundColor";
	public static final String BACKGROUND_DISABLEC_COLOR = "backgroundDisabledColor";
	public static final String BACKGROUND_IMAGE = "backgroundImage";
	public static final String BACKGROUND_SIZE = "backgroundSize";
	public static final String BAR_COLOR = "barColor";
	public static final String BORDER_COLOR = "borderColor";
	public static final String BORDER_SIDES = "borderSides";
	public static final String BORDER_SKIN = "borderSkin";
	public static final String BORDER_STYLE = "borderStyle";
	public static final String BORDER_THICKNESS = "borderThickness";
	public static final String COLOR = "color";
	public static final String CORNER_RADIUS = "cornerRadius";
	public static final String DISABLED_COLOR = "disabledColor";
	public static final String DISABLED_OVERLAY_ALPHA = "disbledOverlayAlpha";
	public static final String DROP_SHADOW_COLOR = "dropShadowColor";
	public static final String DROP_SHADOW_ENABLED = "dropShadowEnabled";

	public static final String FONT_ANTI_ALIAS_TYPE = "fontAntiAliasType";
	public static final String FONT_FAMILY = "fontFamily";
	public static final String FONT_GRID_FIT_TYPE = "fontGridFitType";
	public static final String FONT_SHARPNESS = "fontSharpness";
	public static final String FONT_SIZE = "fontSize";
	public static final String FONT_STYLE = "fontStyle";
	public static final String FONT_THICKNESS = "fontThickness";
	public static final String FONT_WEIGHT = "fontWeight";
	public static final String HORIZONTAL_SCROLL_BAR_STYLE_NAME = "horizontalScrollBarStyleName";

	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String PADDING_TOP = "paddingTop";

	public static final String SHADOW_DIRECTION = "shadowDirection";
	public static final String SHADOW_DISTANCE = "shadowDistance";

	public static final String TEXT_ALIGN = "textAlign";
	public static final String TEXT_DECORATION = "textDecoration";
	public static final String TEXT_INDENT = "textIndent";

	public static final String VERTICAL_SCROLL_BAR_STYLE_NAME = "verticalScrollBarStyleName";

	//event
	public static final String CHILD_ADD = "childAdd";
	public static final String CHILD_INDEX_CHANGE = "childIndexChange";
	public static final String CHILD_REMOVE = "childRemove";
	public static final String DATA_CHANGE = "dataChange";
	public static final String SCROLL = "scroll";

	private List<String> script = new ArrayList<String>();

	//private Element scriptElement;

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(AUTO_LAYOUT, CATEGORY_PROPERTY, true).setAdvanced(true);
		addBooleanModelProperty(CLIP_CONTENT, CATEGORY_PROPERTY, true).setAdvanced(true);
		addNumberModelProperty(CREATION_INDEX, CATEGORY_PROPERTY).setAdvanced(true);
		addListModelProperty(CREATION_POLICY, CATEGORY_PROPERTY, new String[] { "auto", "all", "queued", "none" })
				.setAdvanced(true);
		addStringModelProperty(DEFAULT_BUTTON, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(HORIZONTAL_LINE_SCROLL_SIZE, CATEGORY_PROPERTY, 5).setAdvanced(true);
		addNumberModelProperty(HORIZONTAL_PAGE_SCROLL_SIZE, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addListModelProperty(HORIZONTAL_SCROLL_POLICY, CATEGORY_PROPERTY, new String[] { "auto", "on", "off" });
		addNumberModelProperty(HORIZONTAL_SCROLL_POSITION, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addImageModelProperty(ICON, CATEGORY_PROPERTY);
		addStringModelProperty(LABEL, CATEGORY_PROPERTY);
		addNumberModelProperty(VERTICAL_LINE_SCROLL_SIZE, CATEGORY_PROPERTY, 5).setAdvanced(true);
		addNumberModelProperty(VERTICAL_PAGE_SCROLL_SIZE, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addListModelProperty(VERTICAL_SCROLL_POLICY, CATEGORY_PROPERTY, new String[] { "auto", "on", "off" });
		addNumberModelProperty(VERTICAL_SCROLL_POSITION, CATEGORY_PROPERTY, 0).setAdvanced(true);

		//Styles
		addDoubleModelProperty(BACKGROUND_ALPHA, CATEGORY_STYLE, 1.0);
		addStringModelProperty(BACKGROUND_ATTACHMENT, CATEGORY_STYLE).setAdvanced(true);
		addColorModelProperty(BACKGROUND_COLOR, CATEGORY_STYLE);
		addColorModelProperty(BACKGROUND_DISABLEC_COLOR, CATEGORY_STYLE).setAdvanced(true);
		addImageModelProperty(BACKGROUND_IMAGE, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(BACKGROUND_SIZE, CATEGORY_STYLE).setAdvanced(true);
		addColorModelProperty(BAR_COLOR, CATEGORY_STYLE).setAdvanced(true);
		addColorModelProperty(BORDER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3"));
		addStringModelProperty(BORDER_SIDES, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(BORDER_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(BORDER_STYLE, CATEGORY_STYLE, "inset").setAdvanced(true);
		addNumberModelProperty(BORDER_THICKNESS, CATEGORY_STYLE, 1);
		addColorModelProperty(COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#0B333C"));
		addNumberModelProperty(CORNER_RADIUS, CATEGORY_STYLE, 0);
		addColorModelProperty(DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3")).setAdvanced(true);
		addStringModelProperty(DISABLED_OVERLAY_ALPHA, CATEGORY_STYLE).setAdvanced(true);
		addColorModelProperty(DROP_SHADOW_COLOR, CATEGORY_STYLE).setAdvanced(true);
		addBooleanModelProperty(DROP_SHADOW_ENABLED, CATEGORY_STYLE, false).setAdvanced(true);
		addListModelProperty(FONT_ANTI_ALIAS_TYPE, CATEGORY_STYLE, LIST_FONT_ALIAS_TYPE).setAdvanced(true);
		addStringModelProperty(FONT_FAMILY, CATEGORY_STYLE, "Verdana");
		addListModelProperty(FONT_GRID_FIT_TYPE, CATEGORY_STYLE, LIST_GRID_FIT_TYPE).setAdvanced(true);
		addNumberModelProperty(FONT_SHARPNESS, CATEGORY_STYLE, 1).setAdvanced(true);
		addNumberModelProperty(FONT_SIZE, CATEGORY_STYLE, 10);
		addListModelProperty(FONT_STYLE, CATEGORY_STYLE, new String[] { "normal", "italic" });
		addNumberModelProperty(FONT_THICKNESS, CATEGORY_STYLE, 0).setAdvanced(true);
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, new String[] { "normal", "bold" });
		addStringModelProperty(HORIZONTAL_SCROLL_BAR_STYLE_NAME, CATEGORY_STYLE).setAdvanced(true);

		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 0);
		addListModelProperty(SHADOW_DIRECTION, CATEGORY_STYLE, new String[] { "center" }).setAdvanced(true);
		addNumberModelProperty(SHADOW_DISTANCE, CATEGORY_STYLE, 2).setAdvanced(true);
		addListModelProperty(TEXT_ALIGN, CATEGORY_STYLE, LIST_LEFT_RIGHT_CENTER).setAdvanced(true);
		addListModelProperty(TEXT_DECORATION, CATEGORY_STYLE, LIST_TEXT_DECORATION).setAdvanced(true);
		addNumberModelProperty(TEXT_INDENT, CATEGORY_STYLE, 0).setAdvanced(true);
		addStringModelProperty(VERTICAL_SCROLL_BAR_STYLE_NAME, CATEGORY_STYLE).setAdvanced(true);

		//events
		addStringModelProperty(CHILD_ADD, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(CHILD_INDEX_CHANGE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(CHILD_REMOVE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(DATA_CHANGE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(SCROLL, CATEGORY_EVENT).setAdvanced(true);
	}

	@Override
	public void addChild(int index, IComponentModel child) {
		child.setRoot(this);
		super.addChild(index, child);
	}

	// to XML
	// ----------------------------------------
	@Override
	protected String getChildAllNodeXML() {
		StringBuilder sb = new StringBuilder();
		for (String s : script) {
			sb.append("<").append(AIRPlugin.getDefault().getNameSpacePrefix()).append("Script source=\"").append(s)
					.append("\"/>\n");
		}

		sb.append(super.getChildAllNodeXML());

		return sb.toString();
	}

	public String getScript() {
		if (this.script != null && this.script.size() > 0) {
			return script.get(0);
		} else {
			return null;
		}
	}

	@Override
	public void addScript(String script) {
		this.script.add(script);
		firePropertyChange(KEY_SCRIPT, null, script);
	}

	/**
	 * Whether it is possible to add it as a child component or not?
	 * If it is AbstractComponentModel and not IDecidedParentComonent, it is OK.
	 * @param model
	 * @return
	 */
	@Override
	public boolean canChildComponent(Object model) {
		if (model == null) {
			return false;
		} else if (model instanceof IComponentModel) {
			return model instanceof IDecidedParentComonent ? false : true;
		} else {
			return false;
		}
	}

	/**
	 * return to FlexModel pakage name.
	 * 
	 * @return
	 */
	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

	/**
	 * return flex model name.
	 * @return
	 */
	public String getFlexModelName() {
		return getFlexModelPackageName() + "." + getComponentName();
	}

	@Override
	public int getChildIndex(IComponentModel child) {
		for (int i = 0; i < getChildren().size(); i++) {
			if (child == getChildren().get(i)) {
				return i;
			}
		}
		return -1;
	}

}
