package net.sf.amateras.air.mxml.models;

/**
 * model of mx.core.ScrollControllBase
 * @author ogawahideko
 *
 */
public abstract class AbstractScrollControllBase extends AbstractComponentModel {
	//properties
	public static final String HORIZONTAL_SCROLL_POLICY = "horizontalScrollPolicy";
	public static final String HORIZONTAL_SCROLL_POSITION = "horizontalScrollPosition";

	public static final String VERTICAL_SCROLL_POLICY = "verticalScrollPolicy";
	public static final String VERTICAL_SCROLL_POSITION = "verticalScrollPosition";

	//styles
	public static final String FONT_FAMILY = "fontFamily";
	public static final String FONT_SIZE = "fontSize";
	public static final String FONT_STYLE = "fontStyle";
	public static final String FONT_WEIGHT = "fontWeight";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();

		addListModelProperty(HORIZONTAL_SCROLL_POLICY, CATEGORY_PROPERTY, new String[] { "off", "on", "auto" })
				.setAdvanced(false);
		addNumberModelProperty(HORIZONTAL_SCROLL_POSITION, CATEGORY_PROPERTY, 0).setAdvanced(true);

		addListModelProperty(VERTICAL_SCROLL_POLICY, CATEGORY_PROPERTY, new String[] { "auto", "on", "off" })
				.setAdvanced(false);
		addNumberModelProperty(VERTICAL_SCROLL_POSITION, CATEGORY_PROPERTY, 0).setAdvanced(true);

		addStringModelProperty(FONT_FAMILY, CATEGORY_STYLE, "Verdana").setAdvanced(false);
		addNumberModelProperty(FONT_SIZE, CATEGORY_STYLE, 10).setAdvanced(false);
		addListModelProperty(FONT_STYLE, CATEGORY_STYLE, new String[] { "normal", "italic" }).setAdvanced(false);
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, new String[] { "normal", "bold" }).setAdvanced(false);

	}
}
