package net.sf.amateras.air.mxml.models;

/**
 * model of mx.containers.Accordion
 * 
 * @author ogawahideko
 *
 */
public class AccordionModel extends AbstractContainerModel implements IInstallDefault, ISelectedView {
	private static final int DURATION_DEFAULT_VALUE = 250;

	public static final String COMPONENT_NAME = "Accordion";

	public static final String HEADER_RENDERER = "headerRenderer";
	public static final String HISTORY_MANAGEMENT_ENABLED = "historyManagementEnabled";
	public static final String RESIZE_TO_CONTENT = "resizeToContent";
	public static final String SELECTED_INDEX = "selectedIndex";

	public static final String HEADER_HEIGHT = "headerHeight";
	public static final String HEADER_STYLE_NAME = "headerStyleName";
	public static final String HORIZONTAL_GAP = "horizontalGap";
	public static final String OPEN_DURATION = "openDuration";
	public static final String OPEN_EASING_FUNCTION = "openEasingFunction";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_TOP = "paddingTop";
	public static final String TEXT_ROLL_OVER_COLOR = "textRollOverColor";
	public static final String TEXT_SELECTED_COLOR = "textSelectedColor";
	public static final String VERTICAL_GAP = "verticalGap";

	private int selectedIndex = -1;

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(HEADER_RENDERER, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(HISTORY_MANAGEMENT_ENABLED, CATEGORY_PROPERTY, true).setAdvanced(true);
		addBooleanModelProperty(RESIZE_TO_CONTENT, CATEGORY_PROPERTY, false).setAdvanced(true);
		addNumberModelProperty(SELECTED_INDEX, CATEGORY_PROPERTY, 0);

		addNumberModelProperty(HEADER_HEIGHT, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(HEADER_STYLE_NAME, CATEGORY_STYLE).setAdvanced(true);
		addNumberModelProperty(HORIZONTAL_GAP, CATEGORY_STYLE, 8).setAdvanced(true);
		addNumberModelProperty(OPEN_DURATION, CATEGORY_STYLE, DURATION_DEFAULT_VALUE).setAdvanced(true);
		addStringModelProperty(OPEN_EASING_FUNCTION, CATEGORY_STYLE).setAdvanced(true);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, -1).setAdvanced(true);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, -1).setAdvanced(true);
		addColorModelProperty(TEXT_ROLL_OVER_COLOR, CATEGORY_STYLE).setAdvanced(true);
		addColorModelProperty(TEXT_SELECTED_COLOR, CATEGORY_STYLE).setAdvanced(true);
		addNumberModelProperty(VERTICAL_GAP, CATEGORY_STYLE, -1).setAdvanced(true);
	}

	/**
	 * implement {@link IInstallDefault}
	 */
	public void installDefault() {
		addChild(createCanvasModel("Title1"));
		addChild(createCanvasModel("Title2"));
		addChild(createCanvasModel("Title3"));
		firePropertyChange(KEY_CHILDREN, null, null);
	}

	private CanvasModel createCanvasModel(String name) {
		CanvasModel m = new CanvasModel(name);
		FlexRectangle rec = new FlexRectangle();
		rec.setStrWidth("100%");
		rec.setStrHeight("100%");
		m.setConstraint(rec);
		return m;
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	/**
	 * Whether it is possible to add it as a child component or not?
	 * If it is CanvasModel, it is OK.
	 * @param model
	 * @return
	 */
	@Override
	public boolean canChildComponent(Object model) {
		if (model == null) {
			return false;
		} else {
			return model instanceof AbstractContainerModel ? true : false;
		}
	}

	public void setSelectedIndex(int selectedIndex) {
		this.selectedIndex = selectedIndex;
		fireChildPropertyChange();
	}

	public int getSelectedIndex() {
		return selectedIndex;
	}
}
