package net.sf.amateras.air.mxml.models;

/**
 * model of mx.containers.ApplicationControlBar
 * @author ogawahideko
 *
 */
public class ApplicationControlBarModel extends ControlBarModel {
	private static final int DEFAULT_WIDTH = 50;

	private static final int DEFAULT_HEIGHT = 50;

	public static final String COMPONENT_NAME = "ApplicationControlBar";

	private static final String DOCK = "dock";
	private static final String FILL_ALPHAS = "fillAlphas";
	private static final String FILL_COLORS = "fillColors";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(DOCK, CATEGORY_PROPERTY, false);
		addStringModelProperty(FILL_ALPHAS, CATEGORY_STYLE, "[0, 0]");
		addStringModelProperty(FILL_COLORS, CATEGORY_STYLE, "[0xFFFFFF, 0xFFFFFF]");

		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 4);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 5);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 8);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 8);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

	@Override
	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}

}
