package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.core.Application
 * @author ogawahideko
 *
 */
public class ApplicationModel extends LayoutContainerModel {
	private static final int PADDING_TOP_DEFAULT_VALUE = 24;
	private static final int PADDING_BOTTOM_DEFAULT_VALUE = 24;
	private static final int MODALTRANSPARENCY_DURATION_DEFAULT_VALUE = 100;
	private static final double MODAL_TRANSPARENCY_DEFAULT_VALUE = 0.5;
	private static final int SCRIPT_TIME_LIMIT_DEFAULT_VALUE = 60;
	private static final int SCRIPT_RECURSION_LIMIT_DEFAULT_VALUE = 1000;
	private static final int FRAME_RATE_DEFAULT_VALUE = 24;
	private static final String COMPONENT_NAME = "Application";
	private static final String PACKAGE_NAME = "mx.core";

	//application
	//public static final String ALPHA = "alpha";
	//public static final String BACKGROUND_ALPHA = "backgroundAlpha";
	public static final String FRAME_RATE = "frameRate";
	public static final String HISTORY_MANAGEMENT_ENABLED = "historyManagementEnabled";
	public static final String LAYOUT = "layout";
	public static final String PAGE_TITLE = "pageTitle";
	public static final String PRELOADER = "preloader";
	public static final String RESET_HISTORY = "resetHistory";
	public static final String SCRIPT_RECURSION_LIMIT = "scriptRecursionLimit";
	public static final String SCRIPT_TIME_LIMIT = "scriptTimeLimit";
	public static final String USE_PRELOADER = "usePreloader";
	public static final String VIEW_SOURCE_URL = "viewSourceURL";

	public static final String BACKGROUND_GRADIENT_ALPAS = "backgroundGradientAlphas";
	public static final String BACKGROUND_GRADIENT_COLORS = "backgroundGradientColors";
	public static final String HORIZONTAL_ALIGN = "horizontalAlign";
	public static final String HORIZONTAL_GAP = "horizontalGap";
	public static final String MODAL_TRANSPARENCY = "modalTransparency";
	public static final String MODAL_TRANSPARENCY_BLUR = "modalTransparencyBlur";
	public static final String MODAL_TRANSPARENCY_COLOR = "modalTransparencyColor";
	public static final String MODALTRANSPARENCY_DURATION = "modalTransparencyDuration";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_TOP = "paddingTop";
	public static final String VERTICAL_ALIGN = "verticalAlign";
	public static final String VERTICAL_GAP = "verticalGap";

	public static final String ACTIVETE = "activate";
	public static final String APPLICATION_COMPLETE = "applicationComplete";
	public static final String CLICK = "click";
	public static final String DOUBLE_CLICK = "doubleClick";
	public static final String KEY_DOWN = "keyDown";
	public static final String KEY_UP = "keyUp";
	public static final String MOUSE_DOWN = "mouseDown";
	public static final String MOUSE_MOVE = "mouseMove";
	public static final String MOUSE_UP = "mouseUp";
	public static final String NATIVE_DRAG_COMPLETE = "nativeDragComplete";
	public static final String NATIVE_DRAG_DROP = "nativeDragDrop";
	public static final String NATIVE_DRAG_ENTER = "nativeDragEnter";
	public static final String NATIVE_DRAG_EXIT = "nativeDragExit";
	public static final String NATIVE_DRAG_OVER = "nativeDragOver";
	public static final String NATIVE_DRAG_START = "nativeDragStart";
	public static final String NATIVE_DRAG_UPDATE = "nativeDragUpdate";
	public static final String ERROR = "error";

	public static final String INITIALIZE = "initialize";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addNumberModelProperty(FRAME_RATE, CATEGORY_PROPERTY, FRAME_RATE_DEFAULT_VALUE).setAdvanced(true);
		addBooleanModelProperty(HISTORY_MANAGEMENT_ENABLED, CATEGORY_PROPERTY, true).setAdvanced(true);
		addListModelProperty(LAYOUT, CATEGORY_PROPERTY, new String[] { "vertical", "horizontal", "absolute" });
		addStringModelProperty(PAGE_TITLE, CATEGORY_PROPERTY);
		addStringModelProperty(PRELOADER, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(RESET_HISTORY, CATEGORY_PROPERTY, true).setAdvanced(true);
		addNumberModelProperty(SCRIPT_RECURSION_LIMIT, CATEGORY_PROPERTY, SCRIPT_RECURSION_LIMIT_DEFAULT_VALUE)
				.setAdvanced(true);
		addNumberModelProperty(SCRIPT_TIME_LIMIT, CATEGORY_PROPERTY, SCRIPT_TIME_LIMIT_DEFAULT_VALUE).setAdvanced(true);
		addBooleanModelProperty(USE_PRELOADER, CATEGORY_PROPERTY, true).setAdvanced(true);
		addStringModelProperty(VIEW_SOURCE_URL, CATEGORY_PROPERTY).setAdvanced(true);

		//style
		addStringModelProperty(BACKGROUND_GRADIENT_ALPAS, CATEGORY_STYLE);
		addStringModelProperty(BACKGROUND_GRADIENT_COLORS, CATEGORY_STYLE);
		addListModelProperty(HORIZONTAL_ALIGN, CATEGORY_STYLE, new String[] { "center", "left", "right" });
		addNumberModelProperty(HORIZONTAL_GAP, CATEGORY_STYLE, 8);
		addDoubleModelProperty(MODAL_TRANSPARENCY, CATEGORY_STYLE, MODAL_TRANSPARENCY_DEFAULT_VALUE).setAdvanced(true);
		addNumberModelProperty(MODAL_TRANSPARENCY_BLUR, CATEGORY_STYLE, 3).setAdvanced(true);
		addColorModelProperty(MODAL_TRANSPARENCY_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#DDDDDD")).setAdvanced(true);
		addNumberModelProperty(MODALTRANSPARENCY_DURATION, CATEGORY_STYLE, MODALTRANSPARENCY_DURATION_DEFAULT_VALUE)
				.setAdvanced(true);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, PADDING_BOTTOM_DEFAULT_VALUE);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, PADDING_TOP_DEFAULT_VALUE);
		addListModelProperty(VERTICAL_ALIGN, CATEGORY_STYLE, new String[] { "top", "bottom", "middle" });
		addNumberModelProperty(VERTICAL_GAP, CATEGORY_STYLE, 6);

		//event
		addStringModelProperty(ACTIVETE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(APPLICATION_COMPLETE, CATEGORY_EVENT);
		addStringModelProperty(CLICK, CATEGORY_EVENT);
		addStringModelProperty(DOUBLE_CLICK, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(KEY_DOWN, CATEGORY_EVENT);
		addStringModelProperty(KEY_UP, CATEGORY_EVENT);
		addStringModelProperty(MOUSE_DOWN, CATEGORY_EVENT);
		addStringModelProperty(MOUSE_MOVE, CATEGORY_EVENT);
		addStringModelProperty(MOUSE_UP, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_COMPLETE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_DROP, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_ENTER, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_EXIT, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_OVER, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_START, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(NATIVE_DRAG_UPDATE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(ERROR, CATEGORY_EVENT);

		addStringModelProperty(INITIALIZE, CATEGORY_EVENT);

		//remove
		removePropertySheet(X);
		removePropertySheet(Y);
		removePropertySheet(ID);
		//addWidthHeightModelProperty(WIDTH, CATEGORY_COMMON, "");
		//addWidthHeightModelProperty(HEIGHT, CATEGORY_COMMON, "");

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

	protected String getLocationAttributes() {
		return "";
	}

	@Override
	public boolean canChildComponent(Object model) {
		boolean canDo = super.canChildComponent(model);
		if (!canDo) {
			if (model.getClass() == ApplicationControlBarModel.class) {
				return true;
			}
		}
		return canDo;
	}

}
