package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

public class ButtonModel extends AbstractComponentModel {
	private static final int REPEAT_INTERVAL_DEFAULT_VALUE = 35;
	private static final int REPEAT_DELAY_DEFAULT_VALUE = 500;
	private static final double FOCUS_ALPHA_DEFAULT_VALUE = 0.5;
	public static final String PACKAGE_NAME = "mx.controls";
	public static final String COMPONENT_NAME = "Button";

	//Properties
	public static final String AUTO_REPEAT = "autoRepeat";
	public static final String DATA = "data";
	public static final String EMPHASIZED = "emphasized";
	public static final String FONT_CONTEXT = "fontContext";
	public static final String LABEL = "label";
	public static final String LABEL_PLACEMENT = "labelPlacement";
	public static final String LIST_DATA = "listData";
	public static final String SELECTED = "selected";
	public static final String SELECTED_FIELD = "selectedField";
	public static final String STICKY_HIGHKIGHTING = "stickyHighlighting";
	public static final String TEXT_FIELD = "textField";
	public static final String TOGGLE = "toggle";

	//Styles
	public static final String BORDER_COLOR = "borderColor";
	public static final String COLOR = "color";
	public static final String CORNER_RADIUS = "cornerRadius";
	public static final String DISABLED_COLOR = "disabledColor";
	public static final String DISABLED_ICON = "disabledIcon";
	public static final String DISABLED_SKIN = "disabledSkin";
	public static final String DOWN_ICON = "downIcon";
	public static final String DOWN_SKIN = "downSkin";
	public static final String FILL_ALPHAS = "fillAlphas";
	public static final String FILL_COLORS = "fillColors";
	public static final String FOCUS_ALPHA = "focusAlpha";
	public static final String FOCUS_ROONDED_CORNERS = "focusRoundedCorners";
	public static final String FONT_ANTI_ALIAS_TYPE = "fontAntiAliasType";
	public static final String FONT_FAMILY = "fontFamily";
	public static final String FONT_GRID_FIT_TYPE = "fontGridFitType";
	public static final String FONT_SHARPNESS = "fontSharpness";
	public static final String FONT_SIZE = "fontSize";
	public static final String FONT_STYLE = "fontStyle";
	public static final String FONT_THICKNESS = "fontThickness";
	public static final String FONT_WEIGHT = "fontWeight";
	public static final String HIGHLIGHT_ALPHAS = "highlightAlphas";
	public static final String HORIZONTAL_GAP = "horizontalGap";
	public static final String ICON = "icon";
	public static final String KERNING = "kerning";
	public static final String LEADING = "leading";
	public static final String LETTER_SPACING = "letterSpacing";
	public static final String OVER_ICON = "overIcon";
	public static final String OVER_SKIN = "overSkin";
	public static final String PADDING_TOP = "paddingTop";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String REPEAT_DELAY = "repeatDelay";
	public static final String REPEAT_INTERVAL = "repeatInterval";
	public static final String SELECTED_DISABLED_ICON = "selectedDisabledIcon";
	public static final String SELECTED_DISABLED_SKIN = "selectedDisabledSkin";
	public static final String SELECTED_DOWN_ICON = "selectedDownIcon";
	public static final String SELECTED_DOWN_SKIN = "selectedDownSkin";
	public static final String SELECTED_OVER_ICON = "selectedOverIcon";
	public static final String SELECTED_OVER_SKIN = "selectedOverSkin";
	public static final String SELECTED_UP_ICON = "selectedUpIcon";
	public static final String SELECTED_UP_SKIN = "selectedUpSkin";
	public static final String SKIN = "skin";
	public static final String TEXT_ALIGN = "textAlign";
	public static final String TEXT_DECORATION = "textDecoration";
	public static final String TEXT_INDENT = "textIndent";
	public static final String TEXT_ROLL_OVER_COLOR = "textRollOverColor";
	public static final String TEXT_SELECTED_COLOR = "textSelectedColor";
	public static final String UP_ICON = "upIcon";
	public static final String UP_SKIN = "upSkin";
	public static final String VERTICAL_GAP = "verticalGap";

	public static final String BUTTON_DOWN = "buttonDown";
	public static final String CHANGE = "change";
	public static final String DATA_CHANGE = "dataChange";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(AUTO_REPEAT, CATEGORY_PROPERTY, false).setAdvanced(true);
		addStringModelProperty(DATA, CATEGORY_PROPERTY);
		addBooleanModelProperty(EMPHASIZED, CATEGORY_PROPERTY, false).setAdvanced(true);
		addStringModelProperty(FONT_CONTEXT, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(LABEL, CATEGORY_PROPERTY);
		addListModelProperty(LABEL_PLACEMENT, CATEGORY_PROPERTY, LIST_LABEL_PLACEMENT);
		addStringModelProperty(LIST_DATA, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(SELECTED, CATEGORY_PROPERTY, false);
		addStringModelProperty(SELECTED_FIELD, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(STICKY_HIGHKIGHTING, CATEGORY_PROPERTY, false).setAdvanced(true);
		addStringModelProperty(TEXT_FIELD, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(TOGGLE, CATEGORY_PROPERTY, false);

		addColorModelProperty(BORDER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#B7BABC"));
		addColorModelProperty(COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#0B333C"));
		addNumberModelProperty(CORNER_RADIUS, CATEGORY_STYLE, 4);
		addColorModelProperty(DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3")).setAdvanced(true);
		addImageModelProperty(DISABLED_ICON, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(DISABLED_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addImageModelProperty(DOWN_ICON, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(DOWN_SKIN, CATEGORY_STYLE).setAdvanced(true);

		addStringModelProperty(FILL_ALPHAS, CATEGORY_STYLE, "[0.6, 0.4]").setAdvanced(true);
		addStringModelProperty(FILL_COLORS, CATEGORY_STYLE, "[0xE6EEEE, 0xFFFFFF]").setAdvanced(true);
		addDoubleModelProperty(FOCUS_ALPHA, CATEGORY_STYLE, FOCUS_ALPHA_DEFAULT_VALUE).setAdvanced(true);
		addStringModelProperty(FOCUS_ROONDED_CORNERS, CATEGORY_STYLE).setAdvanced(true);
		addListModelProperty(FONT_ANTI_ALIAS_TYPE, CATEGORY_STYLE, LIST_FONT_ALIAS_TYPE).setAdvanced(true);
		addStringModelProperty(FONT_FAMILY, CATEGORY_STYLE, "Verdana");
		addListModelProperty(FONT_GRID_FIT_TYPE, CATEGORY_STYLE, LIST_GRID_FIT_TYPE).setAdvanced(true);
		addNumberModelProperty(FONT_SHARPNESS, CATEGORY_STYLE, 0).setAdvanced(true);
		addNumberModelProperty(FONT_SIZE, CATEGORY_STYLE, 10);
		addListModelProperty(FONT_STYLE, CATEGORY_STYLE, LIST_FONT_STYLE);
		addNumberModelProperty(FONT_THICKNESS, CATEGORY_STYLE, 0).setAdvanced(true);
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, LIST_FONT_WEIGHT, "bold");
		addStringModelProperty(HIGHLIGHT_ALPHAS, CATEGORY_STYLE, "[0.3, 0.0]").setAdvanced(true);
		addNumberModelProperty(HORIZONTAL_GAP, CATEGORY_STYLE, 2).setAdvanced(true);
		addImageModelProperty(ICON, CATEGORY_STYLE);
		addBooleanModelProperty(KERNING, CATEGORY_STYLE, false).setAdvanced(true);
		addNumberModelProperty(LEADING, CATEGORY_STYLE, 2).setAdvanced(true);
		addNumberModelProperty(LETTER_SPACING, CATEGORY_STYLE, 0).setAdvanced(true);
		addImageModelProperty(OVER_ICON, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(OVER_SKIN, CATEGORY_STYLE).setAdvanced(true);

		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 10);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 10);

		addNumberModelProperty(REPEAT_DELAY, CATEGORY_STYLE, REPEAT_DELAY_DEFAULT_VALUE).setAdvanced(true);
		addNumberModelProperty(REPEAT_INTERVAL, CATEGORY_STYLE, REPEAT_INTERVAL_DEFAULT_VALUE).setAdvanced(true);
		addImageModelProperty(SELECTED_DISABLED_ICON, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(SELECTED_DISABLED_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addImageModelProperty(SELECTED_DOWN_ICON, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(SELECTED_DOWN_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addImageModelProperty(SELECTED_OVER_ICON, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(SELECTED_OVER_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addImageModelProperty(SELECTED_UP_ICON, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(SELECTED_UP_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(SKIN, CATEGORY_STYLE).setAdvanced(true);
		addListModelProperty(TEXT_ALIGN, CATEGORY_STYLE, LIST_LEFT_RIGHT_CENTER, "center");
		addListModelProperty(TEXT_DECORATION, CATEGORY_STYLE, LIST_TEXT_DECORATION);
		addNumberModelProperty(TEXT_INDENT, CATEGORY_STYLE, 0).setAdvanced(true);
		addColorModelProperty(TEXT_ROLL_OVER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#2B333C")).setAdvanced(true);
		addColorModelProperty(TEXT_SELECTED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#000000")).setAdvanced(true);
		addImageModelProperty(UP_ICON, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(UP_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addNumberModelProperty(VERTICAL_GAP, CATEGORY_STYLE, 2).setAdvanced(true);

		addStringModelProperty(BUTTON_DOWN, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(CHANGE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(DATA_CHANGE, CATEGORY_EVENT).setAdvanced(true);

		setAdvancedToModel(CLICK, false);
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}
}
