package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * model of mx.controls.CheckBox
 * 
 * @author ogawahideko
 *
 */
public class CheckBoxModel extends ButtonModel {
	public static final String COMPONENT_NAME = "CheckBox";

	public static final String DISABLED_ICON_COLOR = "disabledIconColor";
	public static final String ICON_COLOR = "iconColor";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addColorModelProperty(DISABLED_ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#999999")).setAdvanced(true);
		addColorModelProperty(ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#2B333C")).setAdvanced(true);
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, LIST_FONT_WEIGHT);
		addListModelProperty(TEXT_ALIGN, CATEGORY_STYLE, LIST_TITLE_ALIGNMENT);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

}
