package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.controls.dataGridClasses.DataGridColumn.
 * @author Hideko Ogawa
 *
 */
public class DataGridColumnModel extends AbstractComponentModel implements IDecidedParentComonent {
	private static final int DEFAULT_HEIGHT = 0;
	private static final int DEFAULT_WIDTH = 100;
	public static final String COMPONENT_NAME = "DataGridColumn";
	public static final String PACKAGE_NAME = "mx.controls.dataGridClasses";

	//properties
	public static final String DATA_FIELD = "dataField";
	public static final String DATA_TIP_FIELD = "dataTipField";
	public static final String DATA_TIP_FUNCTION = "dataTipFunction";
	public static final String EDITABLE = "editable";
	public static final String EDITOR_DATA_FIELD = "editorDataField";
	public static final String EDITOR_HEIGHT_OFFSET = "editorHeightOffset";
	public static final String EDITOR_USERS_ENTER_KEY = "editorUsesEnterKey";
	public static final String EDITOR_WIDTH_OFFSET = "editorWidthOffset";
	public static final String EDITOR_X_OFFSET = "editorXOffset";
	public static final String EDITOR_Y_OFFSET = "editorYOffset";
	public static final String HEADER_RENDERER = "headerRenderer";
	public static final String HEADER_TEXT = "headerText";
	public static final String HEADER_WORD_WRAP = "headerWordWrap";
	public static final String IME_MODE = "imeMode";
	public static final String ITEM_EDITOR = "itemEditor";
	public static final String ITEM_RENDERER = "itemRenderer";
	public static final String LABEL_FUNCTION = "labelFunction";
	public static final String RENDERER_IS_EDITOR = "rendererIsEditor";
	public static final String RESIZABLE = "resizable";
	public static final String SHOW_DATA_TIPS = "showDataTips";
	public static final String SORTABLE = "sortable";
	public static final String SORT_COMPARE_FUNCTION = "sortCompareFunction";
	public static final String SORT_DESCENDING = "sortDescending";
	public static final String VISIBLE = "visible";
	public static final String WIDTH = "width";
	public static final String WORD_WRAP = "wordWrap";

	//Styles
	public static final String BACKGROUND_COLOR = "backgroundColor";
	public static final String COLOR = "color";
	public static final String DISABLED_COLOR = "disabledColor";
	public static final String FONT_ANTI_ALIAS_TYPE = "fontAntiAliasType";
	public static final String FONT_FAMILY = "fontFamily";
	public static final String FONT_GRID_FIT_TYPE = "fontGridFitType";
	public static final String FONT_SHAPNESS = "fontSharpness";
	public static final String FONT_SIZE = "fontSize";
	public static final String FONT_STYLE = "fontStyle";
	public static final String FONT_THICKNESS = "fontThickness";
	public static final String FONT_WEIGHT = "fontWeight";
	public static final String HEADER_STYLE_NAME = "headerStyleName";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String TEXT_ALIGN = "textAlign";
	public static final String TEXT_DECORATION = "textDecoration";
	public static final String TEXT_INDENT = "textIndent";

	public DataGridColumnModel() {
		FlexRectangle rectangle = new FlexRectangle();
		rectangle.setRectangle(0, 0, DEFAULT_WIDTH, DEFAULT_HEIGHT);
		setConstraint(rectangle);
	}

	public DataGridColumnModel(String headerTitle) {
		this();
		setAttribute(HEADER_TEXT, headerTitle);
	}

	@Override
	protected void installModelProperty() {
		addStringModelProperty(ID, CATEGORY_PROPERTY, null);

		addStringModelProperty(DATA_FIELD, CATEGORY_PROPERTY);
		addStringModelProperty(DATA_TIP_FIELD, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(DATA_TIP_FUNCTION, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(EDITABLE, CATEGORY_PROPERTY, true);
		addStringModelProperty(EDITOR_DATA_FIELD, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(EDITOR_HEIGHT_OFFSET, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addBooleanModelProperty(EDITOR_USERS_ENTER_KEY, CATEGORY_PROPERTY, false).setAdvanced(true);
		addNumberModelProperty(EDITOR_WIDTH_OFFSET, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addNumberModelProperty(EDITOR_X_OFFSET, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addNumberModelProperty(EDITOR_Y_OFFSET, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addStringModelProperty(HEADER_RENDERER, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(HEADER_TEXT, CATEGORY_PROPERTY);
		addStringModelProperty(HEADER_WORD_WRAP, CATEGORY_PROPERTY);
		addListModelProperty(IME_MODE, CATEGORY_PROPERTY, LIST_IME_MODE).setAdvanced(true);
		addStringModelProperty(ITEM_EDITOR, CATEGORY_PROPERTY);
		addStringModelProperty(ITEM_RENDERER, CATEGORY_PROPERTY);
		addStringModelProperty(LABEL_FUNCTION, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(MIN_WIDTH, CATEGORY_PROPERTY, 20).setAdvanced(true);
		addBooleanModelProperty(RENDERER_IS_EDITOR, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(RESIZABLE, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(SHOW_DATA_TIPS, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(SORTABLE, CATEGORY_PROPERTY, true);
		addStringModelProperty(SORT_COMPARE_FUNCTION, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(SORT_DESCENDING, CATEGORY_PROPERTY, false).setAdvanced(true);
		addBooleanModelProperty(VISIBLE, CATEGORY_PROPERTY, true);
		addWidthHeightModelProperty(WIDTH, CATEGORY_PROPERTY, "100");
		addBooleanModelProperty(WORD_WRAP, CATEGORY_PROPERTY, false);

		addColorModelProperty(BACKGROUND_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#FFFFFF"));
		addColorModelProperty(COLOR, CATEGORY_STYLE);
		addColorModelProperty(DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3")).setAdvanced(true);
		addListModelProperty(FONT_ANTI_ALIAS_TYPE, CATEGORY_STYLE, LIST_FONT_ALIAS_TYPE).setAdvanced(true);
		addStringModelProperty(FONT_FAMILY, CATEGORY_STYLE);
		addListModelProperty(FONT_GRID_FIT_TYPE, CATEGORY_STYLE, LIST_GRID_FIT_TYPE).setAdvanced(true);
		addNumberModelProperty(FONT_SHAPNESS, CATEGORY_STYLE, 0).setAdvanced(true);
		addNumberModelProperty(FONT_SIZE, CATEGORY_STYLE);
		addListModelProperty(FONT_STYLE, CATEGORY_STYLE, LIST_FONT_STYLE);
		addStringModelProperty(FONT_THICKNESS, CATEGORY_STYLE).setAdvanced(true);
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, LIST_FONT_WEIGHT);
		addStringModelProperty(HEADER_STYLE_NAME, CATEGORY_STYLE).setAdvanced(true);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 0);
		addListModelProperty(TEXT_ALIGN, CATEGORY_STYLE, LIST_LEFT_RIGHT_CENTER, "left");
		addListModelProperty(TEXT_DECORATION, CATEGORY_STYLE, LIST_TEXT_DECORATION);
		addNumberModelProperty(TEXT_INDENT, CATEGORY_STYLE, 0);
	}

	@Override
	protected boolean isOutputAtribute(String propertyName) {
		return X.endsWith(propertyName) || Y.endsWith(propertyName) || HEIGHT.endsWith(propertyName) ? false : true;
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

}
