package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * model of mx.controls.ComboBox
 * 
 * @author ogawahideko
 * 
 */
public class DateFieldModel extends AbstractComboBase {
	private static final double FOCUS_ALPHA_DEFAULT_VALUE = 0.5;

	private static final int MIN_YEAR_DEFAULT_VALUE = 1900;

	private static final int MAX_YEAR_DEFAULT_VALUE = 2100;

	public static final String COMPONENT_NAME = "DateField";

	public static final String DAY_NAMES = "dayNames";
	public static final String DISABLED_DAYS = "disabledDays";
	public static final String DISABLED_RANGES = "disabledRanges";
	public static final String DISPLAYED_MONTH = "displayedMonth";
	public static final String DISPLAYED_YEAR = "displayedYear";
	public static final String DROPDOWN_FACTORY = "dropdownFactory";
	public static final String FIRST_DAY_OF_WEEK = "firstDayOfWeek";
	public static final String FORMAT_STRING = "formatString";
	public static final String LABEL_FUNCTION = "labelFunction";
	public static final String MAX_YEAR = "maxYear";
	public static final String MIN_YEAR = "minYear";
	public static final String MONTH_NAMES = "monthNames";
	public static final String MONTH_SYMBOL = "monthSymbol";
	public static final String PARSE_FUNCTION = "parseFunction";
	public static final String SELECTABLE_RANGE = "selectableRange";
	public static final String SELECTED_DATE = "selectedDate";
	public static final String SHOW_TODAY = "showToday";
	public static final String YEAR_NAVIGATION_ENABLED = "yearNavigationEnabled";
	public static final String YEAR_SYMBOL = "yearSymbol";

	public static final String BORDER_COLOR = "borderColor";
	public static final String BORDER_THICKNESS = "borderThickness";
	public static final String COLOR = "color";
	public static final String DATE_CHOOSER_STYLE_NAME = "dateChooserStyleName";
	public static final String DISABLED_COLOR = "disabledColor";
	public static final String DISABLED_ICON_COLOR = "disabledIconColor";
	public static final String FOCUS_ALPHA = "focusAlpha";
	public static final String FOCUS_ROUNDED_CORNERS = "focusRoundedCorners";
	public static final String FONT_ANTI_ALIAS_TYPE = "fontAntiAliasType";
	public static final String FONT_FAMILY = "fontFamily";
	public static final String FONT_GRID_FIT_TYPE = "fontGridFitType";
	public static final String FONT_SHARPNESS = "fontSharpness";
	public static final String FONT_SIZE = "fontSize";
	public static final String FONT_STYLE = "fontStyle";
	public static final String FONT_THICKNESS = "fontThickness";
	public static final String FONT_WEIGHT = "fontWeight";
	public static final String ICON_COLOR = "iconColor";
	public static final String LEADING = "leading";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String ROLL_OVER_COLOR = "rollOverColor";
	public static final String SELECTION_COLOR = "selectionColor";
	public static final String TEXT_ALIGN = "textAlign";
	public static final String TEXT_DECORATION = "textDecoration";
	public static final String TEXT_INDENT = "textIndent";
	public static final String TODAY_COLOR = "todayColor";

	public static final String CHANGE = "change";
	public static final String CLOSE = "close";
	public static final String DATA_CHANGE = "dataChange";
	public static final String OPEN = "open";
	public static final String SCROLL = "scroll";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(DAY_NAMES, CATEGORY_PROPERTY, "[\"S\", \"M\", \"T\", \"W\", \"T\", \"F\", \"S\"]");
		addStringModelProperty(DISABLED_DAYS, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(DISABLED_RANGES, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(DISPLAYED_MONTH, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(DISPLAYED_YEAR, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(DROPDOWN_FACTORY, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(FIRST_DAY_OF_WEEK, CATEGORY_PROPERTY, 0);
		addStringModelProperty(FORMAT_STRING, CATEGORY_PROPERTY, "MM/DD/YYYY");
		addStringModelProperty(LABEL_FUNCTION, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(MAX_YEAR, CATEGORY_PROPERTY, MAX_YEAR_DEFAULT_VALUE);
		addNumberModelProperty(MIN_YEAR, CATEGORY_PROPERTY, MIN_YEAR_DEFAULT_VALUE);
		addStringModelProperty(MONTH_NAMES, CATEGORY_PROPERTY,
				"[\"January\", \"February\", \"March\", \"April\", \"May\", \"June\", \"July\", "
						+ "\"August\", \"September\", \"October\", \"November\", \"December\"]");
		addStringModelProperty(MONTH_SYMBOL, CATEGORY_PROPERTY);
		addStringModelProperty(PARSE_FUNCTION, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(SELECTABLE_RANGE, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(SELECTED_DATE, CATEGORY_PROPERTY);
		addBooleanModelProperty(SHOW_TODAY, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(YEAR_NAVIGATION_ENABLED, CATEGORY_PROPERTY, false);
		addStringModelProperty(YEAR_SYMBOL, CATEGORY_PROPERTY).setAdvanced(true);

		addColorModelProperty(BORDER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3")).setAdvanced(true);
		addNumberModelProperty(BORDER_THICKNESS, CATEGORY_STYLE, 1).setAdvanced(true);
		addColorModelProperty(COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#0B333C"));
		addStringModelProperty(DATE_CHOOSER_STYLE_NAME, CATEGORY_STYLE).setAdvanced(true);
		addColorModelProperty(DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3")).setAdvanced(true);
		addColorModelProperty(DISABLED_ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#999999")).setAdvanced(true);
		addDoubleModelProperty(FOCUS_ALPHA, CATEGORY_STYLE, FOCUS_ALPHA_DEFAULT_VALUE).setAdvanced(true);
		addStringModelProperty(FOCUS_ROUNDED_CORNERS, CATEGORY_STYLE).setAdvanced(true);
		addListModelProperty(FONT_ANTI_ALIAS_TYPE, CATEGORY_STYLE, LIST_FONT_ALIAS_TYPE).setAdvanced(true);
		addStringModelProperty(FONT_FAMILY, CATEGORY_STYLE, "Verdana");
		addListModelProperty(FONT_GRID_FIT_TYPE, CATEGORY_STYLE, LIST_GRID_FIT_TYPE).setAdvanced(true);
		addNumberModelProperty(FONT_SHARPNESS, CATEGORY_STYLE, 0).setAdvanced(true);
		addNumberModelProperty(FONT_SIZE, CATEGORY_STYLE, 10);
		addListModelProperty(FONT_STYLE, CATEGORY_STYLE, LIST_FONT_STYLE);
		addNumberModelProperty(FONT_THICKNESS, CATEGORY_STYLE, 0).setAdvanced(true);
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, LIST_FONT_WEIGHT);
		addColorModelProperty(ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#111111")).setAdvanced(true);
		addNumberModelProperty(LEADING, CATEGORY_STYLE, 2).setAdvanced(true);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 0).setAdvanced(true);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 0).setAdvanced(true);
		addColorModelProperty(ROLL_OVER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#E3FFD6")).setAdvanced(true);
		addColorModelProperty(SELECTION_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#B7F39B")).setAdvanced(true);
		addListModelProperty(TEXT_ALIGN, CATEGORY_STYLE, LIST_LEFT_RIGHT_CENTER).setAdvanced(true);
		addListModelProperty(TEXT_DECORATION, CATEGORY_STYLE, LIST_TEXT_DECORATION).setAdvanced(true);
		addNumberModelProperty(TEXT_INDENT, CATEGORY_STYLE, 0).setAdvanced(true);
		addColorModelProperty(TODAY_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#x2B333C"));

		addStringModelProperty(CHANGE, CATEGORY_EVENT);
		addStringModelProperty(CLOSE, CATEGORY_EVENT);
		addStringModelProperty(DATA_CHANGE, CATEGORY_EVENT);
		addStringModelProperty(OPEN, CATEGORY_EVENT);
		addStringModelProperty(SCROLL, CATEGORY_EVENT);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

}
