package net.sf.amateras.air.mxml.models;

/**
 * model of mx.controls.List
 * 
 * @author ogawahideko
 */
public class FileSystemListModel extends ListModel {
	public static final String COMPONENT_NAME = "FileSystemList";
	public static final String PACKAGE_NAME = "mx.controls";

	//properties
	public static final String DIRECTORY = "directory";
	public static final String ENUMERATION_MODE = "enumerationMode";
	public static final String EXTENTIONS = "extensions";
	public static final String FILTER_FUNCTION = "filterFunction";
	public static final String NAME_COMPARE_FUNCTION = "nameCompareFunction";
	public static final String SELECTED_PATH = "selectedPath";
	public static final String SELECTED_PATHS = "selectedPaths";
	public static final String SHOW_EXTENSIONS = "showExtensions";
	public static final String SHOW_HIDDEN = "showHidden";
	public static final String SHOW_ICONS = "showIcons";

	public static final String DIRECTORY_ICON = "directoryIcon";
	public static final String FILE_ICON = "fileIcon";

	public static final String DIRECTORY_CHANGE = "directoryChange";
	public static final String DIRECTORY_CHANGING = "directoryChanging";
	public static final String FILE_CHOOSE = "fileChoose";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(DIRECTORY, CATEGORY_PROPERTY);
		addStringModelProperty(ENUMERATION_MODE, CATEGORY_PROPERTY);
		addStringModelProperty(EXTENTIONS, CATEGORY_PROPERTY);
		addStringModelProperty(FILTER_FUNCTION, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(NAME_COMPARE_FUNCTION, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(SELECTED_PATH, CATEGORY_PROPERTY);
		addStringModelProperty(SELECTED_PATHS, CATEGORY_PROPERTY);
		addBooleanModelProperty(SHOW_EXTENSIONS, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(SHOW_HIDDEN, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(SHOW_ICONS, CATEGORY_PROPERTY, true);

		addImageModelProperty(DIRECTORY_ICON, CATEGORY_STYLE);
		addImageModelProperty(FILE_ICON, CATEGORY_STYLE);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

}
