package net.sf.amateras.air.mxml.models;


/**
 * Model of mx.core.LayoutContainer.
 * 
 * @author ogawahideko
 *
 */
public class LayoutContainerModel extends AbstractContainerModel {
	private static final String COMPONENT_NAME = "LayoutContainer";

	//properties
	public static final String LAYOUT = "layout";
	public static final String NAMESPACE = "xmlns:mx";

	//styles
	public static final String HORIZONTAL_ALIGN = "horizontalAlign";
	public static final String HORIZONTAL_GAP = "horizontalGap";
	public static final String VERTICAL_ALIGN = "verticalAlign";
	public static final String VERTICAL_GAP = "verticalGap";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();

		//Properties
		addListModelProperty(LAYOUT, CATEGORY_PROPERTY, new String[] { "vertical", "horizontal", "absolute" });
		addStringModelProperty(NAMESPACE, CATEGORY_PROPERTY, "http://www.adobe.com/2006/mxml");

		// styles
		addListModelProperty(HORIZONTAL_ALIGN, CATEGORY_STYLE, new String[] { "center", "left", "right" });
		addNumberModelProperty(HORIZONTAL_GAP, CATEGORY_STYLE, 8);
		addListModelProperty(VERTICAL_ALIGN, CATEGORY_STYLE, new String[] { "top", "bottom", "middle" });
		addNumberModelProperty(VERTICAL_GAP, CATEGORY_STYLE, 6);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

}
