package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * model of mx.controls.List
 * 
 * @author ogawahideko
 */
public class ListModel extends AbstractListBase {
	public static final String COMPONENT_NAME = "List";
	public static final String PACKAGE_NAME = "mx.controls";

	//properties
	public static final String EDITABLE = "editable";
	public static final String EDITABLED_ITEM_POSITION = "editedItemPosition";
	public static final String EDITOR_DATA_FIELD = "editorDataField";
	public static final String EDITOR_HEIGHT_OFFSET = "editorHeightOffset";
	public static final String EDITOR_USES_ENTER_KEY = "editorUsesEnterKey";
	public static final String EDITOR_WIDTH_OFFSET = "editorWidthOffset";
	public static final String EDITOR_X_OFFSET = "editorXOffset";
	public static final String EDITOR_Y_OFFSET = "editorYOffset";
	public static final String IME_MODE = "imeMode";
	public static final String ITEM_EDITOR = "itemEditor";
	public static final String ITEM_EDITOR_INSTANCE = "itemEditorInstance";
	public static final String RENDERER_IS_EDITOR = "rendererIsEditor";

	//Styles
	public static final String BACKGROUND_DISABLED_COLOR = "backgroundDisabledColor";

	//Events
	public static final String ITEM_EDIT_BEGIN = "itemEditBegin";
	public static final String ITEM_EDIT_END = "itemEditEnd";
	public static final String ITEM_EDIT_BEGINNING = "itemEditBeginning";
	public static final String ITEM_FOCUS_IN = "itemFocusIn";
	public static final String ITEM_FOCUS_OUT = "itemFocusOut";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(EDITABLE, CATEGORY_PROPERTY, false);
		addStringModelProperty(EDITABLED_ITEM_POSITION, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(EDITOR_DATA_FIELD, CATEGORY_PROPERTY, "text").setAdvanced(true);
		addNumberModelProperty(EDITOR_HEIGHT_OFFSET, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addBooleanModelProperty(EDITOR_USES_ENTER_KEY, CATEGORY_PROPERTY, false).setAdvanced(true);
		addNumberModelProperty(EDITOR_WIDTH_OFFSET, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addNumberModelProperty(EDITOR_X_OFFSET, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addNumberModelProperty(EDITOR_Y_OFFSET, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addStringModelProperty(IME_MODE, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(ITEM_EDITOR, CATEGORY_PROPERTY, "TextInput").setAdvanced(true);
		addStringModelProperty(ITEM_EDITOR_INSTANCE, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(RENDERER_IS_EDITOR, CATEGORY_PROPERTY, false).setAdvanced(true);

		addColorModelProperty(BACKGROUND_DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("DDDDDD")).setAdvanced(true);

		addStringModelProperty(ITEM_EDIT_BEGIN, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(ITEM_EDIT_END, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(ITEM_EDIT_BEGINNING, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(ITEM_FOCUS_IN, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(ITEM_FOCUS_OUT, CATEGORY_EVENT).setAdvanced(true);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

}
