package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.controls.NumericStepper.
 * 
 * 
 * @author hideko ogawa
 * @see http://livedocs.adobe.com/flex/3_jp/langref/mx/controls/NumericStepper.html
 */
public class NumericStepperModel extends AbstractComponentModel {
	public static final String PACKAGE_NAME = "mx.controls";
	public static final String COMPONENT_NAME = "NumericStepper";

	//properties
	public static final String IME_MODE = "imeMode";
	public static final String LIST_DATA = "listData";
	public static final String MAX_CHARS = "maxChars";
	public static final String MAXIMUM = "maximum";
	public static final String MINIMUM = "minimum";
	public static final String STEP_SIZE = "stepSize";
	public static final String VALUE = "value";

	//Styles
	public static final String BACKGROUND_ALPHA = "backgroundAlpha";
	public static final String BACKGROUND_COLOR = "backgroundColor";
	public static final String BACKGROUND_DISABLED_COLOR = "backgroundDisabledColor";
	public static final String BACKGROUND_IMAGE = "backgroundImage";
	public static final String BACKGROUND_SIZE = "backgroundSize";
	public static final String BORDER_COLOR = "borderColor";
	public static final String BORDER_SIDES = "borderSides";
	public static final String BORDER_SKIN = "borderSkin";
	public static final String BORDER_STYLE = "borderStyle";
	public static final String BORDER_THICKNESS = "borderThickness";
	public static final String COLOR = "color";
	public static final String CORNER_RADIUS = "cornerRadius";
	public static final String DISABLED_COLOR = "disabledColor";
	public static final String DISABLED_ICON_COLOR = "disabledIconColor";
	public static final String DOWN_ARROW_DISABLED_SKIN = "downArrowDisabledSkin";
	public static final String DOWN_ARROW_DOWN_SKIN = "downArrowDownSkin";
	public static final String DOWN_ARROW_SKIN = "downArrowSkin";
	public static final String DOWN_ARROW_OVER_SKIN = "downArrowOverSkin";
	public static final String DOWN_ARROW_UP_SKIN = "downArrowUpSkin";
	public static final String DROP_SHADOW_ENABLED = "dropShadowEnabled";
	public static final String DROP_SHADOW_COLOR = "dropShadowColor";
	public static final String FOCUS_ALPHA = "focusAlpha";
	public static final String FOCUS_ROUNDED_CORNERS = "focusRoundedCorners";
	public static final String FONT_ANT_ALIAS_TYPE = "fontAntiAliasType";
	public static final String FONT_FAMILY = "fontFamily";
	public static final String FONT_GRID_FIT_TYPE = "fontGridFitType";
	public static final String FONT_SHARPNESS = "fontSharpness";
	public static final String FONT_SIZE = "fontSize";
	public static final String FONT_STYLE = "fontStyle";
	public static final String FONT_THICKNESS = "fontThickness";
	public static final String FONT_WEIGHT = "fontWeight";
	public static final String HIGHLIGHT_ALPHAS = "highlightAlphas";
	public static final String ICON_COLOR = "iconColor";
	public static final String LEADING = "leading";
	public static final String KERNING = "kerning";
	public static final String LETTER_SPACING = "letterSpacing";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String SHADOW_DIRECTION = "shadowDirection";
	public static final String SHADOW_DISTANCE = "shadowDistance";
	public static final String TEXT_ALIGN = "textAlign";
	public static final String TEXT_DECORATION = "textDecoration";
	public static final String TEXT_INDENT = "textIndent";
	public static final String UP_ARROW_DISABLED_SKIN = "upArrowDisabledSkin";
	public static final String UP_ARROW_SKIN = "upArrowSkin";
	public static final String UP_ARROW_DOWN_SKIN = "upArrowDownSkin";
	public static final String UP_ARROW_OVER_SKIN = "upArrowOverSkin";
	public static final String UP_ARROW_UP_SKIN = "upArrowUpSkin";

	//Events
	public static final String CHANGE = "change";
	public static final String DATA_CHANGE = "dataChange";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(IME_MODE, CATEGORY_PROPERTY);
		addStringModelProperty(LIST_DATA, CATEGORY_PROPERTY);
		addNumberModelProperty(MAX_CHARS, CATEGORY_PROPERTY, 10);
		addNumberModelProperty(MAXIMUM, CATEGORY_PROPERTY, 10);
		addNumberModelProperty(MINIMUM, CATEGORY_PROPERTY, 0);
		addNumberModelProperty(STEP_SIZE, CATEGORY_PROPERTY, 1);
		addNumberModelProperty(VALUE, CATEGORY_PROPERTY, 0);

		//Styles
		addDoubleModelProperty(BACKGROUND_ALPHA, CATEGORY_STYLE, 1.0);
		addColorModelProperty(BACKGROUND_COLOR, CATEGORY_STYLE);
		addColorModelProperty(BACKGROUND_DISABLED_COLOR, CATEGORY_STYLE);
		addImageModelProperty(BACKGROUND_IMAGE, CATEGORY_STYLE);
		addStringModelProperty(BACKGROUND_SIZE, CATEGORY_STYLE, "auto");
		addColorModelProperty(BORDER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3"));
		addStringModelProperty(BORDER_SIDES, CATEGORY_STYLE);
		addStringModelProperty(BORDER_SKIN, CATEGORY_STYLE, "mx.skins.halo.HaloBorder").setAdvanced(true);
		addListModelProperty(BORDER_STYLE, CATEGORY_STYLE, LIST_BORDER_STYLE, "inset");
		addNumberModelProperty(BORDER_THICKNESS, CATEGORY_STYLE, 1);
		addColorModelProperty(COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#0B333C"));
		addNumberModelProperty(CORNER_RADIUS, CATEGORY_STYLE, 0);
		addColorModelProperty(DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3"));
		addColorModelProperty(DISABLED_ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#999999"));
		addStringModelProperty(DOWN_ARROW_DISABLED_SKIN, CATEGORY_STYLE, "mx.skins.halo.NumericStepperDownSkin")
				.setAdvanced(true);
		addStringModelProperty(DOWN_ARROW_DOWN_SKIN, CATEGORY_STYLE, "mx.skins.halo.NumericStepperDownSkin")
				.setAdvanced(true);
		addStringModelProperty(DOWN_ARROW_SKIN, CATEGORY_STYLE);
		addStringModelProperty(DOWN_ARROW_OVER_SKIN, CATEGORY_STYLE, "mx.skins.halo.NumericStepperDownSkin")
				.setAdvanced(true);
		addStringModelProperty(DOWN_ARROW_UP_SKIN, CATEGORY_STYLE, "mx.skins.halo.NumericStepperDownSkin").setAdvanced(
				true);
		addColorModelProperty(DROP_SHADOW_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#000000"));
		addBooleanModelProperty(DROP_SHADOW_ENABLED, CATEGORY_STYLE, false);
		addDoubleModelProperty(FOCUS_ALPHA, CATEGORY_STYLE, 0.5);
		addStringModelProperty(FOCUS_ROUNDED_CORNERS, CATEGORY_STYLE);
		addListModelProperty(FONT_ANT_ALIAS_TYPE, CATEGORY_STYLE, LIST_FONT_ALIAS_TYPE);
		addStringModelProperty(FONT_FAMILY, CATEGORY_STYLE, "Verdana");
		addListModelProperty(FONT_GRID_FIT_TYPE, CATEGORY_STYLE, LIST_GRID_FIT_TYPE);
		addNumberModelProperty(FONT_SHARPNESS, CATEGORY_STYLE, 0);
		addNumberModelProperty(FONT_SIZE, CATEGORY_STYLE, 10);
		addListModelProperty(FONT_STYLE, CATEGORY_STYLE, LIST_FONT_STYLE);
		addNumberModelProperty(FONT_THICKNESS, CATEGORY_STYLE, 0);
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, LIST_FONT_WEIGHT);
		addStringModelProperty(HIGHLIGHT_ALPHAS, CATEGORY_STYLE, "[0.3, 0.0]");
		addColorModelProperty(ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#111111"));
		addNumberModelProperty(LEADING, CATEGORY_STYLE, 2);
		addBooleanModelProperty(KERNING, CATEGORY_STYLE, false);
		addNumberModelProperty(LETTER_SPACING, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 0);
		addListModelProperty(SHADOW_DIRECTION, CATEGORY_STYLE, new String[] { "center", "left", "right" });
		addNumberModelProperty(SHADOW_DISTANCE, CATEGORY_STYLE, 2);
		addListModelProperty(TEXT_ALIGN, CATEGORY_STYLE, LIST_LEFT_RIGHT_CENTER);
		addListModelProperty(TEXT_DECORATION, CATEGORY_STYLE, LIST_TEXT_DECORATION);
		addNumberModelProperty(TEXT_INDENT, CATEGORY_STYLE, 0);
		addStringModelProperty(UP_ARROW_DISABLED_SKIN, CATEGORY_STYLE, "mx.skins.halo.NumericStepperUpSkin")
				.setAdvanced(true);
		addStringModelProperty(UP_ARROW_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(UP_ARROW_DOWN_SKIN, CATEGORY_STYLE, "mx.skins.halo.NumericStepperUpSkin").setAdvanced(
				true);
		addStringModelProperty(UP_ARROW_OVER_SKIN, CATEGORY_STYLE, "mx.skins.halo.NumericStepperUpSkin").setAdvanced(
				true);
		addStringModelProperty(UP_ARROW_UP_SKIN, CATEGORY_STYLE, "mx.skins.halo.NumericStepperUpSkin")
				.setAdvanced(true);

		//Events
		addStringModelProperty(CHANGE, CATEGORY_EVENT);
		addStringModelProperty(DATA_CHANGE, CATEGORY_EVENT);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}
}
