package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.containers.Panel
 * 
 * @author ogawahideko
 *
 */
public class PanelModel extends AbstractContainerModel {
	private static final int DEFAULT_WIDTH = 50;

	private static final int DEFAULT_HEIGHT = 50;

	private static final int MODAL_TRANSPARENCY_DURATION_DEFAULT_VALUE = 100;

	private static final double MODAL_TRANSPARENCY_DEFAULT_VALUE = 0.5;

	private static final double BORDER_ALPHA_DEFAULT_VALUE = 0.4;

	public static final String COMPONENT_NAME = "Panel";

	public static final String LAYOUT = "layout";
	public static final String STATUS = "status";
	public static final String TITLE = "title";
	public static final String TITLE_ICON = "titleIcon";

	public static final String BORDER_ALPHA = "borderAlpha";
	public static final String BORDER_THICKNESS_BOTTOM = "borderThicknessBottom";
	public static final String BORDER_THICKNESS_LEFT = "borderThicknessLeft";
	public static final String BORDER_THICKNESS_RIGHT = "borderThicknessRight";
	public static final String BORDER_THICKNESS_TOP = "borderThicknessTop";
	public static final String CONTROL_BAR_STYLE_NAME = "controlBarStyleName";
	public static final String CORNER_RADIUS = "cornerRadius";
	public static final String DROP_SHADOW_ENABLED = "dropShadowEnabled";
	public static final String FOOTER_COLORS = "footerColors";
	public static final String HEADER_COLORS = "headerColors";
	public static final String HEADER_HEIGHT = "headerHeight";
	public static final String HIGHLIGHT_ALPHAS = "highlightAlphas";
	public static final String HORIZINTAL_ALIGN = "horizontalAlign";
	public static final String HORIZONTAL_GAP = "horizontalGap";
	public static final String MODAL_TRANSPARENCY = "modalTransparency";
	public static final String MODAL_TRANSPARENCY_BLUR = "modalTransparencyBlur";
	public static final String MODAL_TRANSPARENCY_COLOR = "modalTransparencyColor";
	public static final String MODAL_TRANSPARENCY_DURATION = "modalTransparencyDuration";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_TOP = "paddingTop";
	public static final String ROUNDED_BOTTOM_CORNERS = "roundedBottomCorners";
	public static final String SHADOW_DIRECTION = "shadowDirection";
	public static final String SHADOW_DISTANCE = "shadowDistance";
	public static final String STATUS_STYLE_NAME = "statusStyleName";
	public static final String TITLE_BACKGROUND_SKIN = "titleBackgroundSkin";
	public static final String TITLE_STYLE_NAME = "titleStyleName";
	public static final String VERTICAL_ALIGN = "verticalAlign";
	public static final String VERTICAL_GAP = "verticalGap";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		//Properties
		addListModelProperty(LAYOUT, CATEGORY_PROPERTY, new String[] { "vertical", "horizontal", "absolute" });
		addStringModelProperty(STATUS, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(TITLE, CATEGORY_PROPERTY);
		addImageModelProperty(TITLE_ICON, CATEGORY_PROPERTY);

		//Style
		addDoubleModelProperty(BORDER_ALPHA, CATEGORY_STYLE, new Double(BORDER_ALPHA_DEFAULT_VALUE));
		addStringModelProperty(BORDER_THICKNESS_BOTTOM, CATEGORY_STYLE);
		addNumberModelProperty(BORDER_THICKNESS_LEFT, CATEGORY_STYLE, 10);
		addNumberModelProperty(BORDER_THICKNESS_RIGHT, CATEGORY_STYLE, 10);
		addNumberModelProperty(BORDER_THICKNESS_TOP, CATEGORY_STYLE, 2);
		addStringModelProperty(CONTROL_BAR_STYLE_NAME, CATEGORY_STYLE).setAdvanced(true);
		addNumberModelProperty(CORNER_RADIUS, CATEGORY_STYLE, 4);
		addBooleanModelProperty(DROP_SHADOW_ENABLED, CATEGORY_STYLE, true).setAdvanced(true);
		addColorModelProperty(FOOTER_COLORS, CATEGORY_STYLE);
		addStringModelProperty(HEADER_HEIGHT, CATEGORY_STYLE);
		addStringModelProperty(HIGHLIGHT_ALPHAS, CATEGORY_STYLE, "[0.3,0]").setAdvanced(true);
		addListModelProperty(HORIZINTAL_ALIGN, CATEGORY_STYLE, new String[] { "left", "center", "right" });
		addNumberModelProperty(HORIZONTAL_GAP, CATEGORY_STYLE, 8);
		addDoubleModelProperty(MODAL_TRANSPARENCY, CATEGORY_STYLE, new Double(MODAL_TRANSPARENCY_DEFAULT_VALUE))
				.setAdvanced(true);
		addNumberModelProperty(MODAL_TRANSPARENCY_BLUR, CATEGORY_STYLE, 3).setAdvanced(true);
		addColorModelProperty(MODAL_TRANSPARENCY_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#DDDDDD")).setAdvanced(true);
		addNumberModelProperty(MODAL_TRANSPARENCY_DURATION, CATEGORY_STYLE, MODAL_TRANSPARENCY_DURATION_DEFAULT_VALUE)
				.setAdvanced(true);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 4);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 4);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 4);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 4);
		addBooleanModelProperty(ROUNDED_BOTTOM_CORNERS, CATEGORY_STYLE, false);
		addListModelProperty(SHADOW_DIRECTION, CATEGORY_STYLE, new String[] { "center", "left", "right" }).setAdvanced(
				true);
		addNumberModelProperty(SHADOW_DISTANCE, CATEGORY_STYLE, 2).setAdvanced(true);
		addStringModelProperty(STATUS_STYLE_NAME, CATEGORY_STYLE, "windowStatus").setAdvanced(true);
		addStringModelProperty(TITLE_BACKGROUND_SKIN, CATEGORY_STYLE, "TitleBackground").setAdvanced(true);
		addStringModelProperty(TITLE_STYLE_NAME, CATEGORY_STYLE, "windowStyles").setAdvanced(true);
		addListModelProperty(VERTICAL_ALIGN, CATEGORY_STYLE, new String[] { "top", "middle", "bottom" });
		addNumberModelProperty(VERTICAL_GAP, CATEGORY_STYLE, 6);

		setAdvancedToModel(LABEL, true);
		setAdvancedToModel(ICON, true);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}

	@Override
	public boolean canChildComponent(Object model) {
		boolean canDo = super.canChildComponent(model);
		if (!canDo) {
			if (model.getClass() == ControlBarModel.class) {
				return true;
			}
		}
		return canDo;
	}
}
