package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.controls.ProgressBar.
 * 
 * 
 * @author hideko ogawa
 * @see http://livedocs.adobe.com/flex/3_jp/langref/mx/controls/ProgressBar.html
 */
public class ProgressBarModel extends AbstractComponentModel {
	public static final String PACKAGE_NAME = "mx.controls";
	public static final String COMPONENT_NAME = "ProgressBar";

	//properties
	public static final String CONVERSION = "conversion";
	public static final String DIRECTION = "direction";
	public static final String INDETERMINATE = "indeterminate";
	public static final String LABEL = "label";
	public static final String LABEL_PLACEMENT = "labelPlacement";
	public static final String MAXIMUM = "maximum";
	public static final String MINIMUM = "minimum";
	public static final String MODE = "mode";
	public static final String SOURCE = "source";

	//Styles
	public static final String BAR_COLOR = "barColor";
	public static final String BAR_SKIN = "barSkin";
	public static final String BORDER_COLOR = "borderColor";
	public static final String COLOR = "color";
	public static final String DISABLED_COLOR = "disabledColor";
	public static final String FONT_ANTI_ALIAS_TYPE = "fontAntiAliasType";
	public static final String FONT_FAMILY = "fontFamily";
	public static final String FONT_GRID_FIT_TYPE = "fontGridFitType";
	public static final String FONT_SHARPNESS = "fontSharpness";
	public static final String FONT_SIZE = "fontSize";
	public static final String FONT_THICKNESS = "fontThickness";
	public static final String FONT_STYLE = "fontStyle";
	public static final String FONT_WEIGHT = "fontWeight";
	public static final String HORIZONTAL_GAP = "horizontalGap";
	public static final String INTERMINATE_MOVE_INTERVAL = "indeterminateMoveInterval";
	public static final String INTERMINATE_SKIN = "indeterminateSkin";
	public static final String KERNING = "kerning";
	public static final String LABEL_WIDTH = "labelWidth";
	public static final String LEADING = "leading";
	public static final String LETTER_SPACING = "letterSpacing";
	public static final String MASK_SKIN = "maskSkin";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String TEXT_ALIGN = "textAlign";
	public static final String TEXT_DECORATION = "textDecoration";
	public static final String TEXT_INDENT = "textIndent";
	public static final String THEME_COLOR = "themeColor";
	public static final String TRACK_COLORS = "trackColors";
	public static final String TRACK_HEIGHT = "trackHeight";
	public static final String TRACK_SKIN = "trackSkin";
	public static final String VERTICAL_GAP = "verticalGap";

	//Events
	public static final String COMPLETE = "complete";
	public static final String HIDE = "hide";
	public static final String PROGRESS = "progress";
	public static final String SHOW = "show";

	//Effects
	public static final String COMPLETE_EFFECT = "completeEffect";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addNumberModelProperty(CONVERSION, CATEGORY_PROPERTY, 1);
		addListModelProperty(DIRECTION, CATEGORY_PROPERTY, new String[] { "right", "left" });
		addBooleanModelProperty(INDETERMINATE, CATEGORY_PROPERTY, false);
		addStringModelProperty(LABEL, CATEGORY_PROPERTY);
		addListModelProperty(LABEL_PLACEMENT, CATEGORY_PROPERTY, LIST_LABEL_PLACEMENT, "bottom");
		addNumberModelProperty(MAXIMUM, CATEGORY_PROPERTY, 0);
		addNumberModelProperty(MINIMUM, CATEGORY_PROPERTY, 0);
		addListModelProperty(MODE, CATEGORY_PROPERTY, new String[] { "event", "manual", "polled" });
		addStringModelProperty(SOURCE, CATEGORY_PROPERTY);

		//Styles
		addColorModelProperty(BAR_COLOR, CATEGORY_STYLE);
		addStringModelProperty(BAR_SKIN, CATEGORY_STYLE, "mx.skins.halo.ProgressBarSkin").setAdvanced(true);
		addColorModelProperty(BORDER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3"));
		addColorModelProperty(COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#0B333C"));
		addColorModelProperty(DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3"));
		addListModelProperty(FONT_ANTI_ALIAS_TYPE, CATEGORY_STYLE, LIST_FONT_ALIAS_TYPE);
		addStringModelProperty(FONT_FAMILY, CATEGORY_STYLE, "Verdana");
		addListModelProperty(FONT_GRID_FIT_TYPE, CATEGORY_STYLE, LIST_GRID_FIT_TYPE);
		addNumberModelProperty(FONT_SHARPNESS, CATEGORY_STYLE, 0);
		addNumberModelProperty(FONT_SIZE, CATEGORY_STYLE, 10);
		addListModelProperty(FONT_STYLE, CATEGORY_STYLE, LIST_FONT_STYLE);
		addNumberModelProperty(FONT_THICKNESS, CATEGORY_STYLE, 0);
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, LIST_FONT_WEIGHT);
		addNumberModelProperty(HORIZONTAL_GAP, CATEGORY_STYLE, 8);
		addNumberModelProperty(INTERMINATE_MOVE_INTERVAL, CATEGORY_STYLE, 26);
		addStringModelProperty(INTERMINATE_SKIN, CATEGORY_STYLE, "mx.skins.halo.ProgressIndeterminateSkin")
				.setAdvanced(true);
		addBooleanModelProperty(KERNING, CATEGORY_STYLE, false);
		addNumberModelProperty(LABEL_WIDTH, CATEGORY_STYLE);
		addNumberModelProperty(LEADING, CATEGORY_STYLE, 2);
		addNumberModelProperty(LETTER_SPACING, CATEGORY_STYLE, 0);
		addStringModelProperty(MASK_SKIN, CATEGORY_STYLE, "mx.skins.halo.ProgressMaskSkin").setAdvanced(true);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 0);
		addListModelProperty(TEXT_ALIGN, CATEGORY_STYLE, LIST_LEFT_RIGHT_CENTER);
		addListModelProperty(TEXT_DECORATION, CATEGORY_STYLE, LIST_TEXT_DECORATION);
		addNumberModelProperty(TEXT_INDENT, CATEGORY_STYLE, 0);
		addListModelProperty(THEME_COLOR, CATEGORY_STYLE, LIST_THEME_COLOR);
		addStringModelProperty(TRACK_COLORS, CATEGORY_STYLE, "[0xE6EEEE, 0xE6EEEE]");
		addNumberModelProperty(TRACK_HEIGHT, CATEGORY_STYLE);
		addStringModelProperty(TRACK_SKIN, CATEGORY_STYLE, "mx.skins.halo.ProgressTrackSkin").setAdvanced(true);
		addNumberModelProperty(VERTICAL_GAP, CATEGORY_STYLE, 6);

		//Events
		addStringModelProperty(COMPLETE, CATEGORY_EVENT);
		addStringModelProperty(HIDE, CATEGORY_EVENT);
		addStringModelProperty(PROGRESS, CATEGORY_EVENT);
		addStringModelProperty(SHOW, CATEGORY_EVENT);

		//Effects
		addStringModelProperty(COMPLETE_EFFECT, CATEGORY_EFFECT).setAdvanced(true);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}
}
