package net.sf.amateras.air.mxml.models;

import java.util.HashMap;
import java.util.Map;

/**
 * Property of Model is managed. 
 * If Property is set with putProperties beforehand, Property can be changed. 
 * 
 * @author Hideko Ogawa
 *
 */
public class PropertyManager {

	private PropertyManager() {
	}

	private static Map<String, Map<Object, ModelProperty>> maps = new HashMap<String, Map<Object, ModelProperty>>();

	public static Map<Object, ModelProperty> getProperties(String className) {
		return maps.get(className);
	}

	public static void putProperties(String className, Map<Object, ModelProperty> properties) {
		maps.put(className, properties);
	}

}
