package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.controls.Slider.
 * 
 * 
 * @author hideko ogawa
 * @see http://livedocs.adobe.com/flex/3_jp/langref/mx/controls/sliderClasses/Slider.html
 */
public abstract class SliderBaseModel extends AbstractComponentModel {
	public static final String PACKAGE_NAME = "mx.controls.sliderClasses";
	public static final String COMPONENT_NAME = "Slider";

	//properties
	public static final String ALLOW_THUMB_OVERLAP = "allowThumbOverlap";
	public static final String ALLOW_TRACK_CLICK = "allowTrackClick";
	public static final String DATA_TIP_FORMAT_FUNCTION = "dataTipFormatFunction";
	public static final String DIRECTION = "direction";
	public static final String LABELS = "labels";
	public static final String LIVE_DRAGGING = "liveDragging";
	public static final String MAXIMUM = "maximum";
	public static final String MINIMUM = "minimum";
	public static final String SHOW_DATA_TIP = "showDataTip";
	public static final String SLIDER_DATA_TIP_CLASS = "sliderDataTipClass";
	public static final String SLIDER_THUMB_CLASS = "sliderThumbClass";
	public static final String SNAP_INTERVAL = "snapInterval";
	public static final String THUMB_COUNT = "thumbCount";
	public static final String TICK_INTERVAL = "tickInterval";
	public static final String TICK_VALUES = "tickValues";
	public static final String VALUE = "value";
	public static final String VALUES = "values";

	//Styles
	public static final String BORDER_COLOR = "borderColor";
	public static final String DATA_TIP_OFFSET = "dataTipOffset";
	public static final String DATA_TIP_PRECISION = "dataTipPrecision";
	public static final String DATA_TIP_STYLE_NAME = "dataTipStyleName";
	public static final String FILL_ALPHAS = "fillAlphas";
	public static final String FILL_COLORS = "fillColors";
	public static final String INVERT_THUMB_DIRECTION = "invertThumbDirection";
	public static final String LABEL_OFFSET = "labelOffset";
	public static final String LABEL_STYLE_NAME = "labelStyleName";
	public static final String SHOW_TRACK_HIGHTLIGHT = "showTrackHighlight";
	public static final String SLIDE_DURATION = "slideDuration";
	public static final String SLIDE_EASING_FUNCTION = "slideEasingFunction";
	public static final String THUMB_DISABLED_SKIN = "thumbDisabledSkin";
	public static final String THUMB_DOWN_SKIN = "thumbDownSkin";
	public static final String THUMB_OFFSET = "thumbOffset";
	public static final String THUMB_OVER_SKIN = "thumbOverSkin";
	public static final String THUMB_UP_SKIN = "thumbUpSkin";
	public static final String TICK_COLOR = "tickColor";
	public static final String TICK_LENGTH = "tickLength";
	public static final String TICK_OFFSET = "tickOffset";
	public static final String TICK_THICKNESS = "tickThickness";
	public static final String TRACK_COLORS = "trackColors";
	public static final String TRACK_HEIGHLIGHT_SKIN = "tracHighlightSkin";
	public static final String TRACK_MARGIN = "trackMargin";
	public static final String TRACK_SKIN = "trackSkin";

	//Events
	public static final String CHANGE = "change";
	public static final String THUMB_DRAG = "thumbDrag";
	public static final String THUMB_PRESS = "thumbPress";
	public static final String THUMB_RELEASE = "thumbRelease";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(ALLOW_THUMB_OVERLAP, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(ALLOW_TRACK_CLICK, CATEGORY_PROPERTY, true);
		addStringModelProperty(DATA_TIP_FORMAT_FUNCTION, CATEGORY_PROPERTY).setAdvanced(true);
		addListModelProperty(DIRECTION, CATEGORY_PROPERTY, new String[] { "horizontal", "vertical" });
		addStringModelProperty(LABELS, CATEGORY_PROPERTY);
		addBooleanModelProperty(LIVE_DRAGGING, CATEGORY_PROPERTY, false);
		addNumberModelProperty(MAXIMUM, CATEGORY_PROPERTY, 10);
		addNumberModelProperty(MINIMUM, CATEGORY_PROPERTY, 0);
		addBooleanModelProperty(SHOW_DATA_TIP, CATEGORY_PROPERTY, true);
		addStringModelProperty(SLIDER_DATA_TIP_CLASS, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(SLIDER_THUMB_CLASS, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(SNAP_INTERVAL, CATEGORY_PROPERTY, 0);
		addListModelProperty(THUMB_COUNT, CATEGORY_PROPERTY, new String[] { "1", "2" });
		addNumberModelProperty(TICK_INTERVAL, CATEGORY_PROPERTY, 0);
		addStringModelProperty(TICK_VALUES, CATEGORY_PROPERTY);
		addNumberModelProperty(VALUE, CATEGORY_PROPERTY);
		addStringModelProperty(VALUES, CATEGORY_PROPERTY);

		//Styles
		addColorModelProperty(BORDER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#919999"));
		addNumberModelProperty(DATA_TIP_OFFSET, CATEGORY_STYLE, 16);
		addNumberModelProperty(DATA_TIP_PRECISION, CATEGORY_STYLE, 2);
		addStringModelProperty(DATA_TIP_STYLE_NAME, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(FILL_ALPHAS, CATEGORY_PROPERTY, "[0.6, 0.4, 0.75, 0.65]");
		addStringModelProperty(FILL_COLORS, CATEGORY_PROPERTY, "[0xFFFFFF, 0xCCCCCC, 0xFFFFFF, 0xEEEEEE]");
		addBooleanModelProperty(INVERT_THUMB_DIRECTION, CATEGORY_PROPERTY, false);
		addNumberModelProperty(LABEL_OFFSET, CATEGORY_PROPERTY, -10);
		addStringModelProperty(LABEL_STYLE_NAME, CATEGORY_PROPERTY).setAdvanced(true);
		addBooleanModelProperty(SHOW_TRACK_HIGHTLIGHT, CATEGORY_PROPERTY, false);
		addNumberModelProperty(SLIDE_DURATION, CATEGORY_PROPERTY, 300);
		addStringModelProperty(SLIDE_EASING_FUNCTION, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(THUMB_DISABLED_SKIN, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(THUMB_DOWN_SKIN, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(THUMB_OFFSET, CATEGORY_PROPERTY, 0);
		addStringModelProperty(THUMB_OVER_SKIN, CATEGORY_PROPERTY).setAdvanced(true);
		addStringModelProperty(THUMB_UP_SKIN, CATEGORY_PROPERTY).setAdvanced(true);
		addColorModelProperty(TICK_COLOR, CATEGORY_PROPERTY, ColorUtil.toRGB("#6F7777"));
		addNumberModelProperty(TICK_LENGTH, CATEGORY_PROPERTY, 3);
		addNumberModelProperty(TICK_OFFSET, CATEGORY_PROPERTY, -6);
		addNumberModelProperty(TICK_THICKNESS, CATEGORY_PROPERTY, 1);
		addStringModelProperty(TRACK_COLORS, CATEGORY_PROPERTY, "[0xEEEEEE, 0xFFFFFF]");
		addStringModelProperty(TRACK_HEIGHLIGHT_SKIN, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(TRACK_MARGIN, CATEGORY_PROPERTY);
		addStringModelProperty(TRACK_SKIN, CATEGORY_PROPERTY).setAdvanced(true);

		//Events
		addStringModelProperty(CHANGE, CATEGORY_EVENT);
		addStringModelProperty(THUMB_DRAG, CATEGORY_EVENT);
		addStringModelProperty(THUMB_PRESS, CATEGORY_EVENT);
		addStringModelProperty(THUMB_RELEASE, CATEGORY_EVENT);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

}
