package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.containers.TabNavigator
 * 
 * @author ogawahideko
 *
 */
public class TabNavigatorModel extends ViewStackModel implements IInstallDefault, ISelectedView {
	public static final String COMPONENT_NAME = "TabNavigator";

	public static final String FILL_ALPHAS = "fillAlphas";
	public static final String FILL_COLORS = "fillColors";
	public static final String FIRST_TAB_STYLE_NAME = "firstTabStyleName";
	public static final String FOCUS_ALPHA = "focusAlpha";
	public static final String FOCUS_ROUNDED_CORNERS = "focusRoundedCorners";
	public static final String HORIZONTAL_ALIGN = "horizontalAlign";
	//public static final String HORIZONTAL_GAP = "horizontalGap";
	public static final String LAST_TAB_STYLE_NAME = "lastTabStyleName";
	public static final String SELECTED_TAB_TEXT_STYLE_NAME = "selectedTabTextStyleName";
	public static final String TAB_HEIGHT = "tabHeight";
	public static final String TAB_OFFSET = "tabOffset";
	public static final String TAB_STYLE_NAME = "tabStyleName";
	public static final String TAB_WIDTH = "tabWidth";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(FILL_ALPHAS, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(FILL_COLORS, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(FIRST_TAB_STYLE_NAME, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(FOCUS_ALPHA, CATEGORY_STYLE, "0.4").setAdvanced(true);
		addStringModelProperty(FOCUS_ROUNDED_CORNERS, CATEGORY_STYLE).setAdvanced(true);
		addListModelProperty(HORIZONTAL_ALIGN, CATEGORY_STYLE, new String[] { "left", "center", "right" });
		addNumberModelProperty(HORIZONTAL_GAP, CATEGORY_STYLE, -1);
		addStringModelProperty(LAST_TAB_STYLE_NAME, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(SELECTED_TAB_TEXT_STYLE_NAME, CATEGORY_STYLE).setAdvanced(true);
		addNumberModelProperty(TAB_HEIGHT, CATEGORY_STYLE);
		addNumberModelProperty(TAB_OFFSET, CATEGORY_STYLE, 0);
		addStringModelProperty(TAB_STYLE_NAME, CATEGORY_STYLE);
		addNumberModelProperty(TAB_WIDTH, CATEGORY_STYLE);

		removePropertySheet(PADDING_TOP);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	/**
	 * implements IInstallDefault.
	 */
	public void installDefault() {
		BoxModel box = new BoxModel();
		box.setAttribute(BoxModel.LABEL, "tab1");
		addChild(box);
		box = new BoxModel();
		box.setAttribute(BoxModel.LABEL, "tab2");
		addChild(box);
	}

	/**
	 * Whether it is possible to add it as a child component or not?
	 * If it is DataGridColumnModel, it is OK.
	 * @param model
	 * @return
	 */
	@Override
	public boolean canChildComponent(Object model) {
		if (model == null) {
			return false;
		} else {
			return model instanceof AbstractContainerModel ? true : false;
		}
	}
}
