package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.controls.TextInput
 * 
 * @author ogawahideko
 *
 */
public class TextInputModel extends AbstractComponentModel {
	private static final int DEFAULT_HEIGHT = 22;
	private static final int DEFAULT_WIDTH = 160;
	private static final double FOCUS_ALPHA_DEFAULT_VALUE = 0.4;
	public static final String PACKAGE_NAME = "mx.controls";
	public static final String COMPONENT_NAME = "TextInput";

	public static final String CONDENSE_WHITE = "condenseWhite";
	public static final String DATA = "data";
	public static final String DISPLAY_AS_PASSWORD = "displayAsPassword";
	public static final String EDITABLE = "editable";
	public static final String HORIZONTAL_SCROLL_POSITION = "horizontalScrollPosition";
	public static final String HTML_TEXT = "htmlText";
	public static final String IME_MODE = "imeMode";
	public static final String LENGTH = "length";
	public static final String LIST_DATA = "listData";
	public static final String MAX_CHARS = "maxChars";
	public static final String RESTRICT = "restrict";
	public static final String SELECTION_BEGIN_INDEX = "selectionBeginIndex";
	public static final String SELECTION_END_INDEX = "selectionEndIndex";
	public static final String TEXT = "text";

	public static final String BACKGROUND_ALPHA = "backgroundAlpha";
	public static final String BACKGROUND_COLOR = "backgroundColor";
	public static final String BACKGROUND_DISABLED_COLOR = "backgroundDisabledColor";
	public static final String BACKGROUND_IMAGE = "backgroundImage";
	public static final String BACKGROUND_SIZE = "backgroundSize";
	public static final String BORDER_COLOR = "borderColor";
	public static final String BORDER_SIDES = "borderSides";
	public static final String BORDER_SKIN = "borderSkin";
	public static final String BORDER_STYLE = "borderStyle";
	public static final String BORDER_THICKNESS = "borderThickness";
	public static final String COLOR = "color";
	public static final String CORNER_RADIUS = "cornerRadius";
	public static final String DISABLED_COLOR = "disabledColor";
	public static final String DROP_SHADOW_COLOR = "dropShadowColor";
	public static final String DROP_SHADOW_ENABLED = "dropShadowEnabled";
	public static final String FOCUS_ALPHA = "focusAlpha";
	public static final String FOCUS_ROUNDED_CORNERS = "focusRoundedCorners";
	public static final String FONT_ANTI_ALIAS_TYPE = "fontAntiAliasType";
	public static final String FONT_FAMILY = "fontFamily";
	public static final String FONT_GRID_FIT_TYPE = "fontGridFitType";
	public static final String FONT_SHARPNESS = "fontSharpness";
	public static final String FONT_SIZE = "fontSize";
	public static final String FONT_STYLE = "fontStyle";
	public static final String FONT_THICKNESS = "fontThickness";
	public static final String FONT_WEIGHT = "fontWeight";
	public static final String LETTER_SPACING = "letterSpacing";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String PADDING_TOP = "paddingTop";
	public static final String SHADOW_DIRECTION = "shadowDirection";
	public static final String SHADOW_DISTANCE = "shadowDistance";
	public static final String TEXT_ALIGN = "textAlign";
	public static final String TEXT_DECORATION = "textDecoration";
	public static final String TEXT_INDENT = "textIndent";

	public static final String CHANGE = "change";
	public static final String DATA_CHANGE = "dataChange";
	public static final String ENTER = "enter";
	public static final String TEXT_INPUT = "textInput";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(CONDENSE_WHITE, CATEGORY_PROPERTY, false).setAdvanced(true);
		addStringModelProperty(DATA, CATEGORY_PROPERTY);
		addBooleanModelProperty(DISPLAY_AS_PASSWORD, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(EDITABLE, CATEGORY_PROPERTY, true);
		addNumberModelProperty(HORIZONTAL_SCROLL_POSITION, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addStringModelProperty(HTML_TEXT, CATEGORY_PROPERTY);
		addListModelProperty(IME_MODE, CATEGORY_PROPERTY, LIST_IME_MODE);
		addNumberModelProperty(LENGTH, CATEGORY_PROPERTY, 0);
		addStringModelProperty(LIST_DATA, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(MAX_CHARS, CATEGORY_PROPERTY, 0);
		addStringModelProperty(RESTRICT, CATEGORY_PROPERTY).setAdvanced(true);
		addNumberModelProperty(SELECTION_BEGIN_INDEX, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addNumberModelProperty(SELECTION_END_INDEX, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addStringModelProperty(TEXT, CATEGORY_PROPERTY);

		addDoubleModelProperty(BACKGROUND_ALPHA, CATEGORY_STYLE, 1.0);
		addColorModelProperty(BACKGROUND_COLOR, CATEGORY_STYLE);
		addColorModelProperty(BACKGROUND_DISABLED_COLOR, CATEGORY_STYLE).setAdvanced(true);
		addImageModelProperty(BACKGROUND_IMAGE, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(BACKGROUND_SIZE, CATEGORY_STYLE, "auto").setAdvanced(true);
		addColorModelProperty(BORDER_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#B7BABC"));
		addStringModelProperty(BORDER_SIDES, CATEGORY_STYLE, "left top right bottom").setAdvanced(true);
		addStringModelProperty(BORDER_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addListModelProperty(BORDER_STYLE, CATEGORY_STYLE, LIST_BORDER_STYLE, "inset");
		addNumberModelProperty(BORDER_THICKNESS, CATEGORY_STYLE, 1);

		addColorModelProperty(COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#0B333C"));
		addNumberModelProperty(CORNER_RADIUS, CATEGORY_STYLE, 0);
		addColorModelProperty(DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3")).setAdvanced(true);
		addColorModelProperty(DROP_SHADOW_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#000000")).setAdvanced(true);
		addBooleanModelProperty(DROP_SHADOW_ENABLED, CATEGORY_STYLE, false).setAdvanced(true);
		addDoubleModelProperty(FOCUS_ALPHA, CATEGORY_STYLE, FOCUS_ALPHA_DEFAULT_VALUE).setAdvanced(true);
		addStringModelProperty(FOCUS_ROUNDED_CORNERS, CATEGORY_STYLE, "tl tr bl br").setAdvanced(true);
		addListModelProperty(FONT_ANTI_ALIAS_TYPE, CATEGORY_STYLE, LIST_FONT_ALIAS_TYPE).setAdvanced(true);
		addStringModelProperty(FONT_FAMILY, CATEGORY_STYLE, "Verdana");
		addListModelProperty(FONT_GRID_FIT_TYPE, CATEGORY_STYLE, LIST_GRID_FIT_TYPE).setAdvanced(true);
		addNumberModelProperty(FONT_SHARPNESS, CATEGORY_STYLE, 0).setAdvanced(true);
		addNumberModelProperty(FONT_SIZE, CATEGORY_STYLE, 10);
		addListModelProperty(FONT_STYLE, CATEGORY_STYLE, LIST_FONT_STYLE);
		addNumberModelProperty(FONT_THICKNESS, CATEGORY_STYLE, 0).setAdvanced(true);
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, LIST_FONT_WEIGHT);
		addNumberModelProperty(LETTER_SPACING, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 0).setAdvanced(true);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 0).setAdvanced(true);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 0).setAdvanced(true);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 0).setAdvanced(true);
		addListModelProperty(SHADOW_DIRECTION, CATEGORY_STYLE, LIST_LEFT_RIGHT_CENTER, "center").setAdvanced(true);
		addNumberModelProperty(SHADOW_DISTANCE, CATEGORY_STYLE, 2).setAdvanced(true);
		addListModelProperty(TEXT_ALIGN, CATEGORY_STYLE, LIST_LEFT_RIGHT_CENTER, "left");
		addListModelProperty(TEXT_DECORATION, CATEGORY_STYLE, LIST_TEXT_DECORATION);
		addNumberModelProperty(TEXT_INDENT, CATEGORY_STYLE, 0);

		addStringModelProperty(CHANGE, CATEGORY_EVENT);
		addStringModelProperty(DATA_CHANGE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(ENTER, CATEGORY_EVENT);
		addStringModelProperty(TEXT_INPUT, CATEGORY_EVENT).setAdvanced(true);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}

	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

}
