package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.containers.TitleWindow
 * 
 * @author ogawahideko
 *
 */
public class TitleWindowModel extends PanelModel {
	public static final String COMPONENT_NAME = "TitleWindow";

	public static final String SHOW_CLOSE_BUTTON = "showCloseButton";
	public static final String CLOSE_BUTTON_DISABLED_SKIN = "closeButtonDisabledSkin";
	public static final String CLOSE_BUTTON_DOWN_SKIN = "closeButtonDownSkin";
	public static final String CLOSE_BUTTON_OVER_SKIN = "closeButtonOverSkin";
	public static final String CLOSE_BUTTON_UP_SKIN = "closeButtonUpSkin";

	public static final String CLOSE = "close";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(SHOW_CLOSE_BUTTON, CATEGORY_PROPERTY, false);
		addStringModelProperty(CLOSE_BUTTON_DISABLED_SKIN, CATEGORY_PROPERTY, "CloseButtonDisabled").setAdvanced(true);
		addStringModelProperty(CLOSE_BUTTON_DOWN_SKIN, CATEGORY_PROPERTY, "CloseButtonDown").setAdvanced(true);
		addStringModelProperty(CLOSE_BUTTON_OVER_SKIN, CATEGORY_PROPERTY, "CloseButtonOver").setAdvanced(true);
		addStringModelProperty(CLOSE_BUTTON_UP_SKIN, CATEGORY_PROPERTY, "CloseButtonUp").setAdvanced(true);

		addStringModelProperty(CLOSE, CATEGORY_EVENT);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public boolean canChildComponent(Object model) {
		boolean canDo = super.canChildComponent(model);
		if (!canDo) {
			if (model.getClass() == ApplicationControlBarModel.class) {
				return true;
			}
		}
		return canDo;
	}

}
