package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.containers.ViewStack.
 * 
 * @author ogawahideko
 *
 */
public class ViewStackModel extends AbstractContainerModel implements ISelectedView {

	public static final String COMPONENT_NAME = "ViewStack";

	public static final String HISTORY_MANAGEMENT_ENABLED = "historyManagementEnabled";
	public static final String RESIZE_TO_CONTENT = "resizeToContent";
	public static final String SELECTED_INDEX = "selectedIndex";

	public static final String HORIZONTAL_GAP = "horizontalGap";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_TOP = "paddingTop";
	public static final String VERTICAL_GAP = "verticalGap";

	private int selectedIndex = -1;

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(HISTORY_MANAGEMENT_ENABLED, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(RESIZE_TO_CONTENT, CATEGORY_PROPERTY, false).setAdvanced(true);
		addNumberModelProperty(SELECTED_INDEX, CATEGORY_PROPERTY, 0);

		addNumberModelProperty(HORIZONTAL_GAP, CATEGORY_STYLE, 8);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 0);
		addNumberModelProperty(VERTICAL_GAP, CATEGORY_STYLE, 6);

	}

	@Override
	public void removeChild(IComponentModel child) {
		int removeIndex = getChildIndex(child);
		super.removeChild(child);
		if (removeIndex == selectedIndex) {
			if (selectedIndex < getChildren().size()) {
				setSelectedIndex(selectedIndex);
			} else {
				setSelectedIndex(-1);
			}
		}
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	public void setSelectedIndex(int selectedIndex) {
		this.selectedIndex = selectedIndex;
		fireChildPropertyChange();
	}

	public int getSelectedIndex() {
		return selectedIndex;
	}

}
