package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.core.Window.
 * 
 * @author ogawahideko
 *
 */
public class WindowModel extends LayoutContainerModel {
	private static final int MAX_WIDTH_DEFAULT_VALUE = 10000;
	private static final int MAX_HEIGHT_DEFAULT_VALUE = 10000;
	private static final String COMPONENT_NAME = "Window";

	//properties
	public static final String ALWAYS_IN_FRONT = "alwaysInFront";
	public static final String HEIGHT = "height";
	public static final String MAX_HEIGHT = "maxHeight";
	public static final String MAXIMIZABLE = "maximizable";
	public static final String MAX_WIDTH = "maxWidth";
	public static final String MENU = "menu";
	public static final String MIN_HEIGHT = "minHeight";
	public static final String MINIMIZABLE = "minimizable";
	public static final String MIN_WIDTH = "minWidth";
	public static final String RESIZABLE = "resizable";
	public static final String SHOW_GRIPPER = "showGripper";
	public static final String SHOW_STATUS_BAR = "showStatusBar";
	public static final String SHOW_TITLE_BAR = "showTitleBar";
	public static final String STATUS = "status";
	public static final String STATUS_BAR_FACTORY = "statusBarFactory";
	public static final String SYSTEM_CHROME = "systemChrome";
	public static final String SYSTEM_TRAY_ICON_MENU = "systemTrayIconMenu";
	public static final String TITLE = "title";
	public static final String TITLE_BAR_FACTORY = "titleBarFactory";
	public static final String TITLE_ICON = "titleIcon";
	public static final String TRANSPARENT = "transparent";
	public static final String TYPE = "type";
	public static final String VISIBLE = "visible";
	public static final String WIDTH = "width";

	//styles
	public static final String BUTTON_ALIGNMENT = "buttonAlignment";
	public static final String BUTTON_PADDING = "buttonPadding";
	public static final String CLOSE_BUTTON_SKIN = "closeButtonSkin";
	public static final String GRIPPER_PADDING = "gripperPadding";
	public static final String GRIPPER_STYLE_NAME = "gripperStyleName";
	public static final String HEADER_HEIGHT = "headerHeight";
	public static final String MAXIMIZE_BUTTON_SKIN = "maximizeButtonSkin";
	public static final String MINIMIZE_BUTTON_SKIN = "minimizeButtonSkin";
	public static final String RESTORE_BUTTON_SKIN = "restoreButtonSkin";
	public static final String SHOW_FLEX_CHROME = "showFlexChrome";
	public static final String STATUS_BAR_BACKGROUND_COLOR = "statusBarBackgroundColor";
	public static final String STATUS_BAR_BACKGROUND_SKIN = "statusBarBackgroundSkin";
	public static final String STATUS_TEXT_STYLE_NAME = "statusTextStyleName";
	public static final String TITLE_ALIGNMENT = "titleAlignment";
	public static final String TITLE_BAR_BACKGROUND_SKIN = "titleBarBackgroundSkin";
	public static final String TITLE_BAR_BUTTON_PADDING = "titleBarButtonPadding";
	public static final String TITLE_BAR_CLOLORS = "titleBarColors";
	public static final String TITLE_TEXT_STYLE_NAME = "titleTextStyleName";

	//Effects
	public static final String CLOSE_EFECT = "closeEffect";
	public static final String MINIMIZE_EFFECT = "minimizeEffect";
	public static final String UNMINIMIZE_EFFECT = "unminimizeEffect";

	//Events
	public static final String APPLICATION_ACTIVATE = "applicationActivate";
	public static final String APPLICATION_DEACTIVATE = "applicationDeactivate";
	public static final String CLOSE = "close";
	public static final String CLOSING = "closing";
	public static final String DISPLAY_STAGE_CHANGE = "displayStateChange";
	public static final String DISPLAY_STAGE_CHANGING = "displayStateChanging";
	public static final String INVOLE = "invoke";
	public static final String MOVING = "moving";
	public static final String NETWORK_CHANGE = "networkChange";
	public static final String RESIZING = "resizing";
	public static final String WINDOW_ACTIVATE = "windowActivate";
	public static final String WINDOW_COMPLETE = "windowComplete";
	public static final String WINDOW_DEACTIVATE = "windowDeactivate";
	public static final String WINDOW_MOVE = "windowMove";
	public static final String WINDOW_RESIZE = "windowResize";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();

		//Properties
		addBooleanModelProperty(ALWAYS_IN_FRONT, CATEGORY_PROPERTY, false);
		addWidthHeightModelProperty(HEIGHT, CATEGORY_LAYOUT, "100");
		addNumberModelProperty(MAX_HEIGHT, CATEGORY_PROPERTY, MAX_HEIGHT_DEFAULT_VALUE).setAdvanced(true);
		addBooleanModelProperty(MAXIMIZABLE, CATEGORY_PROPERTY, true).setAdvanced(true);
		addNumberModelProperty(MAX_WIDTH, CATEGORY_PROPERTY, MAX_WIDTH_DEFAULT_VALUE).setAdvanced(true);
		addStringModelProperty(MENU, CATEGORY_PROPERTY);
		addNumberModelProperty(MIN_HEIGHT, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addBooleanModelProperty(MINIMIZABLE, CATEGORY_PROPERTY, true).setAdvanced(true);
		addNumberModelProperty(MIN_WIDTH, CATEGORY_PROPERTY, 0).setAdvanced(true);
		addBooleanModelProperty(RESIZABLE, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(SHOW_GRIPPER, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(SHOW_STATUS_BAR, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(SHOW_TITLE_BAR, CATEGORY_PROPERTY, true);
		addStringModelProperty(STATUS, CATEGORY_PROPERTY);
		addStringModelProperty(STATUS_BAR_FACTORY, CATEGORY_PROPERTY).setAdvanced(true);
		addListModelProperty(SYSTEM_CHROME, CATEGORY_PROPERTY, LIST_SYSTEM_CHROME, "standard");
		addStringModelProperty(TITLE, CATEGORY_PROPERTY);
		addStringModelProperty(TITLE_BAR_FACTORY, CATEGORY_PROPERTY).setAdvanced(true);
		addImageModelProperty(TITLE_ICON, CATEGORY_PROPERTY);
		addBooleanModelProperty(TRANSPARENT, CATEGORY_PROPERTY, false);
		addListModelProperty(TYPE, CATEGORY_PROPERTY, LIST_WINDOW_TYPE, "normal");
		addBooleanModelProperty(VISIBLE, CATEGORY_PROPERTY, true);
		addWidthHeightModelProperty(WIDTH, CATEGORY_LAYOUT, "100");

		//Styles
		addListModelProperty(BUTTON_ALIGNMENT, CATEGORY_STYLE, LIST_BUTTON_ALIGNMENT, "auto");
		addNumberModelProperty(BUTTON_PADDING, CATEGORY_STYLE, 2);
		addStringModelProperty(CLOSE_BUTTON_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addNumberModelProperty(GRIPPER_PADDING, CATEGORY_STYLE, 3);
		addStringModelProperty(GRIPPER_STYLE_NAME, CATEGORY_STYLE).setAdvanced(true);
		addNumberModelProperty(HEADER_HEIGHT, CATEGORY_STYLE);
		addStringModelProperty(MAXIMIZE_BUTTON_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(MINIMIZE_BUTTON_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(RESTORE_BUTTON_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addBooleanModelProperty(SHOW_FLEX_CHROME, CATEGORY_STYLE, true);
		addColorModelProperty(STATUS_BAR_BACKGROUND_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#C0C0C0"));
		addStringModelProperty(STATUS_BAR_BACKGROUND_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addStringModelProperty(STATUS_TEXT_STYLE_NAME, CATEGORY_STYLE).setAdvanced(true);
		addListModelProperty(TITLE_ALIGNMENT, CATEGORY_STYLE, LIST_TITLE_ALIGNMENT, "auto");
		addStringModelProperty(TITLE_BAR_BACKGROUND_SKIN, CATEGORY_STYLE).setAdvanced(true);
		addNumberModelProperty(TITLE_BAR_BUTTON_PADDING, CATEGORY_STYLE, 5);
		addStringModelProperty(TITLE_BAR_CLOLORS, CATEGORY_STYLE);
		addStringModelProperty(TITLE_TEXT_STYLE_NAME, CATEGORY_STYLE).setAdvanced(true);

		addStringModelProperty(CLOSE_EFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(MINIMIZE_EFFECT, CATEGORY_EFFECT).setAdvanced(true);
		addStringModelProperty(UNMINIMIZE_EFFECT, CATEGORY_EFFECT).setAdvanced(true);

		addStringModelProperty(APPLICATION_ACTIVATE, CATEGORY_EVENT);
		addStringModelProperty(APPLICATION_DEACTIVATE, CATEGORY_EVENT);
		addStringModelProperty(CLOSE, CATEGORY_EVENT);
		addStringModelProperty(CLOSING, CATEGORY_EVENT);
		addStringModelProperty(DISPLAY_STAGE_CHANGE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(DISPLAY_STAGE_CHANGING, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(INVOLE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(MOVING, CATEGORY_EVENT);
		addStringModelProperty(NETWORK_CHANGE, CATEGORY_EVENT);
		addStringModelProperty(RESIZING, CATEGORY_EVENT);
		addStringModelProperty(WINDOW_ACTIVATE, CATEGORY_EVENT);
		addStringModelProperty(WINDOW_COMPLETE, CATEGORY_EVENT);
		addStringModelProperty(WINDOW_DEACTIVATE, CATEGORY_EVENT).setAdvanced(true);
		addStringModelProperty(WINDOW_MOVE, CATEGORY_EVENT);
		addStringModelProperty(WINDOW_RESIZE, CATEGORY_EVENT);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public boolean canChildComponent(Object model) {
		boolean canDo = super.canChildComponent(model);
		if (!canDo) {
			if (model.getClass() == ApplicationControlBarModel.class) {
				return true;
			}
		}
		return canDo;
	}

}
