package net.sf.amateras.air.mxml.parser;

import java.util.Iterator;

import net.sf.amateras.air.mxml.ElementWrapper;
import net.sf.amateras.air.mxml.MXMLLoader;
import net.sf.amateras.air.mxml.models.FlexRectangle;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;
import net.sf.amateras.air.mxml.models.IModel;
import net.sf.amateras.air.util.ColorUtil;

import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * 
 * @author ogawahideko
 */
public abstract class AbstractMXMLParser {

	/**
	 * parse element to model
	 * @param elements
	 * @return
	 */
	public IModel parse(ElementWrapper element, IContainerModel root) {
		IModel model = createModel();
		if (model instanceof IComponentModel) {
			((IComponentModel) model).setRoot(root);
		}

		parseAttribute(model, element);
		parseChildren(model, element);
		return model;
	}

	/**
	 * create element model
	 * @return
	 */
	protected abstract IModel createModel();

	/**
	 * parse attribute.
	 * @param model
	 * @param element
	 */
	protected void parseAttribute(IModel model, ElementWrapper element) {
		// parse attribute
		Iterator<Object> iterator = model.getModelProperties().keySet().iterator();
		while (iterator.hasNext()) {
			String key = (String) iterator.next();
			String value = element.getAttribute(key.substring(1));

			IPropertyDescriptor descriptor = model.getModelProperties().get(key).getDescriptor();
			if (value != null && value.length() > 0) {
				if (descriptor instanceof ColorPropertyDescriptor) {
					try {
						RGB rgb = ColorUtil.toRGB(value);
						if (rgb != null) {
							model.setPropertyValue(key, rgb);
						} else {
							model.setPropertyValue(key, value);

						}
					} catch (Exception e) {
						model.setPropertyValue(key, value);
					}
					//				} else if (descriptor instanceof NumberPropertyDescriptor) {
					//					model.setPropertyValue(key, Integer.valueOf(value));
					//				} else if (descriptor instanceof DoublePropertyDescriptor) {
					//					model.setPropertyValue(key, Double.valueOf(value));
					//
					//				} else if (descriptor instanceof BooleanPropertyDescriptor) {
					//					if (((BooleanPropertyDescriptor) descriptor).getDefaultValue() 
					//!= Boolean.parseBoolean(value)) {
					//						model.setPropertyValue(key, new Boolean(value));
					//					}
				} else {
					if (value.length() > 0) {
						model.setPropertyValue(key, value);
					}
				}
			}
		}

		FlexRectangle rectangle = null;
		if (model instanceof IComponentModel) {
			rectangle = getConstraint((IComponentModel) model, element);
			((IComponentModel) model).setConstraint(rectangle);
		}

		model.setAdditionalAttributes(element.getAdditionalAttributes());
	}

	/**
	 * parse children model.
	 * @param model
	 * @param element
	 */
	protected void parseChildren(IModel model, ElementWrapper element) {
		// parse children
		NodeList children = element.getElement().getChildNodes();
		for (int i = 0; i < children.getLength(); i++) {
			Node node = children.item(i);
			if (node instanceof Element) {
				parseChildElement(model, (Element) node);
			}
		}
	}

	/**
	 * parse child element.
	 * @param root
	 * @param e
	 */
	protected void parseChildElement(IModel root, Element e) {
		MXMLLoader.parseElement(root, e);
	}

	/**
	 * get FlexRectangle
	 * @param model
	 * @param element
	 * @return
	 */
	private FlexRectangle getConstraint(IComponentModel model, ElementWrapper element) {
		FlexRectangle rect = new FlexRectangle();

		String x = element.getAttribute("x");
		String y = element.getAttribute("y");
		String width = element.getAttribute("width");
		String height = element.getAttribute("height");

		rect.setStrX(x);
		rect.setStrY(y);
		rect.setStrWidth(width);
		rect.setStrHeight(height);

		return rect;
	}

}
