package net.sf.amateras.air.wizards.export;

import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.UIUtil;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * create Self-Signed Digital Certificate dialog.
 * @author ogawahideko
 *
 */
public class CreateCertificateDialog extends TitleAreaDialog {
	private Text certificateName;
	private Text organaizationalUnit;
	private Text organaizationalName;
	private Text country;
	private Text password;
	private Text type;
	private Text saveAs;
	private Text storeText;
	private Text passText;
	private IProject project;

	private List<CheckEntry> needText = new ArrayList<CheckEntry>();

	public CreateCertificateDialog(Shell parentShell, IProject project, Text storeText, Text passText) {
		super(parentShell);
		this.project = project;
		this.storeText = storeText;
		this.passText = passText;
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		setTitle(getMessage("CREATE_CERTIFICATE"));

		Composite area = (Composite) super.createDialogArea(parent);
		Composite composite = new Composite(area, SWT.NULL);
		composite.setLayout(new GridLayout(2, false));
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		certificateName = createText("CertificateName", composite, true);
		password = createText("Password", composite, true);
		type = createText("Type", composite, true);

		Group group = new Group(area, SWT.NULL);
		group.setText("optional");
		group.setLayout(new GridLayout(2, false));
		group.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		organaizationalUnit = createText("OrganaizationalUnit", group, false);
		organaizationalName = createText("OrganaizationalName", group, false);
		country = createText("Country", group, false);
		saveAs = createFileText("Save as", composite, true);

		return parent;
	}

	@Override
	protected Control createContents(Composite parent) {
		Control control = super.createContents(parent);
		certificateName.setText("SelfSigned");
		type.setText("1024-RSA");

		saveAs.setText(project.getName() + ".p12");
		doValidate();
		return control;
	}

	@Override
	protected void okPressed() {
		storeText.setText(this.saveAs.getText());
		passText.setText(this.password.getText());
		ArrayList<String> args = new ArrayList<String>();
		args.add("-certificate");
		args.add("-cn");
		args.add(certificateName.getText());
		if (organaizationalUnit.getText().length() != 0) {
			args.add("-ou");
			args.add(organaizationalUnit.getText());
		}
		if (organaizationalName.getText().length() != 0) {
			args.add("-o");
			args.add(organaizationalName.getText());
		}
		if (country.getText().length() != 0) {
			args.add("-c");
			args.add(country.getText());
		}
		args.add(type.getText());
		args.add(saveAs.getText());
		args.add(password.getText());

		ADTRunner runner = new ADTRunner();
		runner.run(project, args);
		super.okPressed();
	}

	private Text createText(String label, Composite parent, boolean isNeed) {
		UIUtil.createLabel(label, parent);
		Text text = new Text(parent, SWT.BORDER);
		text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		if (isNeed) {
			needText.add(new CheckEntry(text, label));
			text.addModifyListener(new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					doValidate();
				}
			});
		}
		return text;
	}

	private Text createFileText(String label, Composite parent, boolean isNeed) {
		UIUtil.createLabel(label, parent);
		Composite panel = new Composite(parent, SWT.NULL);
		panel.setLayout(new GridLayout(2, false));
		panel.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		final Text text = new Text(panel, SWT.BORDER);
		text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		if (isNeed) {
			needText.add(new CheckEntry(text, label));
			text.addModifyListener(new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					doValidate();
				}
			});
		}
		UIUtil.createBrowseFileButton(text, panel);
		return text;
	}

	private void doValidate() {
		for (CheckEntry check : needText) {
			if (check.getText().getText().length() == 0) {
				setErrorMessage(getMessage("IS_NEED", check.getMessage()));
				getButton(IDialogConstants.OK_ID).setEnabled(false);
				return;
			}
		}
		setErrorMessage(null);
		getButton(IDialogConstants.OK_ID).setEnabled(true);
	}

	private String getMessage(String key, Object... args) {
		return AIRPlugin.getResourceString(key, args);
	}

	class CheckEntry {
		private Text text;
		private String message;

		CheckEntry(Text text, String message) {
			this.text = text;
			this.message = message;
		}

		public Text getText() {
			return text;
		}

		public void setText(Text text) {
			this.text = text;
		}

		public String getMessage() {
			return message;
		}

		public void setMessage(String message) {
			this.message = message;
		}
	}

}
