package net.sf.amateras.air.wizards.export;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.UIUtil;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

/**
 * This wizard exports project files as AIR package.
 * 
 * @author Naoki Takezoe
 */
public class ExportAIRWizard extends Wizard implements IExportWizard {

	private IStructuredSelection selection;
	private ExportAIRWizardPage mainPage;

	/**
	 * Creates a wizard for exporting workspace resources to the local file system.
	 */
	public ExportAIRWizard() {
	}

	@Override
	public void addPages() {
		super.addPages();

		if (selection != null && !selection.isEmpty()) {
			Object obj = selection.getFirstElement();
			IProject project = null;
			if (obj instanceof IProject) {
				project = (IProject) obj;
			} else if (obj instanceof IResource) {
				project = ((IResource) obj).getProject();
			} else if (obj instanceof IAdaptable) {
				project = (IProject) ((IAdaptable) obj).getAdapter(IProject.class);
			}
			if (project != null) {
				mainPage = new ExportAIRWizardPage(project);
				addPage(mainPage);
				return;
			}
		} else {
			UIUtil.openErrorDialog(AIRPlugin.getResourceString("EXPORT_PROJECT_NOT_SELECTED"));
		}

	}

	public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
		this.selection = currentSelection;
		setWindowTitle("Export AIR Package");
		setDefaultPageImageDescriptor(AIRPlugin.getImageDescriptor("icons/exportapp_wiz.png"));
		setNeedsProgressMonitor(true);
	}

	@Override
	public boolean performFinish() {
		mainPage.finish();
		return true;
		//return mainPage.finish();
	}
}
