/*
 * Decompiled with CFR 0.152.
 */
package tk.stepcounter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import tk.stepcounter.Main;
import tk.stepcounter.format.FormatterFactory;
import tk.stepcounter.gui.ConfigManager;
import tk.stepcounter.gui.MainWindowListener;
import tk.stepcounter.gui.StringUtility;

public class MainWindow
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 5954076353117692515L;
    private String fontName = "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af";
    private int fontSize = 12;
    private JButton buttonExecute = new JButton("Execute");
    private JComboBox comboFormat = new JComboBox();
    private JTextArea textArea = new JTextArea();
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private JList list = new JList(this.model);
    private JButton buttonAdd = new JButton("Add");
    private JButton buttonRemove = new JButton("Remove");
    private ConfigManager config = new ConfigManager(new File("stepcounter.conf"));
    private File lastDirectory = null;

    public MainWindow() {
        this.loadConfig();
        this.initComponents();
        this.setSize(500, 450);
    }

    private void initComponents() {
        this.setTitle("STEP COUNTER");
        this.addWindowListener(new MainWindowListener(this));
        this.buttonExecute.addActionListener(this);
        this.buttonAdd.addActionListener(this);
        this.buttonRemove.addActionListener(this);
        this.comboFormat.addItem("Default");
        this.comboFormat.addItem("CSV");
        JScrollPane scrText = new JScrollPane(this.textArea);
        JScrollPane scrList = new JScrollPane(this.list);
        this.list.setSelectionMode(2);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BorderLayout());
        panel1.add((Component)scrList, "Center");
        panel1.add((Component)new JLabel("Search Files"), "North");
        JPanel panel3 = new JPanel();
        panel3.add(this.buttonAdd);
        panel3.add(this.buttonRemove);
        JPanel panel5 = new JPanel();
        panel5.setLayout(new FlowLayout(0));
        panel5.add(new JLabel("Format"));
        panel5.add(this.comboFormat);
        panel5.add(this.buttonExecute);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)panel3, "West");
        panel2.add((Component)panel5, "East");
        JPanel panel4 = new JPanel();
        panel4.setLayout(new BorderLayout());
        panel4.add((Component)panel2, "North");
        panel4.add((Component)scrText, "Center");
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)panel4, "Center");
        cp.add((Component)panel1, "North");
        this.textArea.setFont(new Font(this.fontName, 0, this.fontSize));
    }

    public void appendText(String text) {
        this.textArea.append(text);
        this.textArea.setCaretPosition(this.textArea.getText().length());
    }

    public void clearText() {
        this.textArea.setText("");
    }

    public void saveConfig() {
        try {
            String[] files = new String[this.model.getSize()];
            int i = 0;
            while (i < this.model.getSize()) {
                files[i] = ((File)this.model.getElementAt(i)).toString();
                ++i;
            }
            this.config.setProperty("Path", files);
            this.config.setProperty("FontName", this.fontName);
            this.config.setProperty("FontSize", String.valueOf(this.fontSize));
            this.config.save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadConfig() {
        try {
            String fontSize;
            String[] files = this.config.getPropertyValues("Path");
            int i = 0;
            while (i < files.length) {
                this.model.addElement(new File(files[i]));
                ++i;
            }
            String fontName = this.config.getProperty("FontName");
            if (fontName != null) {
                this.fontName = fontName;
            }
            if ((fontSize = this.config.getProperty("FontSize")) != null) {
                this.fontSize = Integer.parseInt(fontSize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object[] files;
        Object obj = evt.getSource();
        if (obj == this.buttonExecute) {
            File[] files2 = new File[this.model.getSize()];
            int i = 0;
            while (i < this.model.getSize()) {
                files2[i] = (File)this.model.getElementAt(i);
                ++i;
            }
            String format = (String)this.comboFormat.getSelectedItem();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            System.setErr(new PrintStream(out));
            Main counter = new Main();
            counter.setFiles(files2);
            counter.setFormatter(FormatterFactory.getFormatter(format));
            try {
                counter.executeCount(null);
                byte[] buf = out.toByteArray();
                if (buf != null && buf.length > 0) {
                    this.appendText(StringUtility.replace(new String(buf, 0, buf.length), "\r\n", "\n"));
                }
                out.close();
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
        } else if (obj == this.buttonAdd) {
            File[] files3;
            JFileChooser chooser = new JFileChooser(this.lastDirectory);
            chooser.setFileSelectionMode(2);
            chooser.setMultiSelectionEnabled(true);
            if (chooser.showOpenDialog(this) == 0 && (files3 = chooser.getSelectedFiles()) != null && files3.length > 0) {
                int i = 0;
                while (i < files3.length) {
                    this.model.addElement(files3[i]);
                    ++i;
                }
                this.lastDirectory = files3[0].getParentFile();
            }
        } else if (obj == this.buttonRemove && (files = this.list.getSelectedValues()) != null) {
            int i = 0;
            while (i < files.length) {
                this.model.removeElement(files[i]);
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        MainWindow window = new MainWindow();
        window.setVisible(true);
    }
}

