/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.context;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.seasar.fisshplate.core.element.IteratorBlock;
import org.seasar.fisshplate.core.element.Suspend;

public class FPContext {
    private HSSFSheet outSheet;
    private int currentRowNum;
    private int currentCellNum;
    private Map data;
    private boolean shouldHeaderOut;
    private boolean shouldFooterOut;
    private boolean skipMerge = false;
    private HSSFPatriarch patriarch;
    private IteratorBlock currentIterator;
    private Set suspendedSet = new HashSet();

    public FPContext(HSSFSheet out, Map data) {
        this.outSheet = out;
        this.data = data;
        this.init();
    }

    public void init() {
        this.currentCellNum = 0;
        this.currentRowNum = 0;
    }

    public void nextRow() {
        this.currentCellNum = 0;
        ++this.currentRowNum;
    }

    public void nextCell() {
        ++this.currentCellNum;
    }

    public Map getData() {
        return this.data;
    }

    public HSSFRow getCurrentRow() {
        HSSFRow row = this.outSheet.getRow(this.currentRowNum);
        if (row == null) {
            row = this.outSheet.createRow(this.currentRowNum);
        }
        return row;
    }

    public HSSFRow createCurrentRow() {
        return this.outSheet.createRow(this.currentRowNum);
    }

    public HSSFRow moveCurrentRowTo(int rowNum) {
        this.currentRowNum = rowNum;
        return this.getCurrentRow();
    }

    public HSSFCell getCurrentCell() {
        HSSFRow row = this.getCurrentRow();
        HSSFCell cell = row.getCell(this.currentCellNum);
        if (cell == null) {
            cell = row.createCell(this.currentCellNum);
        }
        return cell;
    }

    public HSSFCell moveCurrentCellTo(int cellNum) {
        this.currentCellNum = cellNum;
        return this.getCurrentCell();
    }

    public int getCurrentRowNum() {
        return this.currentRowNum;
    }

    public int getCurrentCellNum() {
        return this.currentCellNum;
    }

    public HSSFSheet getOutSheet() {
        return this.outSheet;
    }

    public boolean shouldHeaderOut() {
        return this.shouldHeaderOut;
    }

    public void setShouldHeaderOut(boolean should) {
        this.shouldHeaderOut = should;
    }

    public boolean shouldFooterOut() {
        return this.shouldFooterOut;
    }

    public void setShouldFooterOut(boolean should) {
        this.shouldFooterOut = should;
    }

    public boolean isSkipMerge() {
        return this.skipMerge;
    }

    public void setSkipMerge(boolean skipMerge) {
        this.skipMerge = skipMerge;
    }

    public HSSFPatriarch getPartriarch() {
        if (this.patriarch == null) {
            this.patriarch = this.outSheet.createDrawingPatriarch();
        }
        return this.patriarch;
    }

    public IteratorBlock getCurrentIterator() {
        return this.currentIterator;
    }

    public void setCurrentIterator(IteratorBlock currentIterator) {
        this.currentIterator = currentIterator;
    }

    public void clearCurrentIterator() {
        this.currentIterator = null;
    }

    public boolean inIteratorBlock() {
        return this.currentIterator != null;
    }

    public void addSuspendedSet(Suspend suspend) {
        this.suspendedSet.add(suspend);
    }

    public Set getSuspendedSet() {
        return this.suspendedSet;
    }
}

