/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.fisshplate.core.element.AbstractBlock;
import org.seasar.fisshplate.core.element.HorizontalIteratorBlock;
import org.seasar.fisshplate.core.parser.FPParser;
import org.seasar.fisshplate.core.parser.RowParser;
import org.seasar.fisshplate.exception.FPParseException;
import org.seasar.fisshplate.wrapper.CellWrapper;

public class HorizontalIteratorBlockParser
implements RowParser {
    private static final Pattern pat = Pattern.compile("^\\s*#hforeach\\s+(\\S+)\\s*:\\s*(\\S+)(\\s+index=(\\S+))*\\s*$");

    public boolean process(CellWrapper cell, FPParser parser) throws FPParseException {
        String value = cell.getStringValue();
        Matcher mat = pat.matcher(value);
        if (!mat.find()) {
            return false;
        }
        AbstractBlock block = this.buildElement(cell, mat);
        parser.addBlockElement(block);
        return true;
    }

    private AbstractBlock buildElement(CellWrapper cell, Matcher mat) throws FPParseException {
        String varName = mat.group(1);
        String iteratorName = mat.group(2);
        String indexName = mat.group(4);
        return new HorizontalIteratorBlock(varName, iteratorName, indexName, cell);
    }
}

