/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.exception;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.seasar.fisshplate.util.ResourceUtil;
import org.seasar.fisshplate.wrapper.RowWrapper;

public class FPException
extends Exception {
    private static final long serialVersionUID = 4301708318614085971L;
    private static final Object[] EMPTY_ARGS = new Object[0];
    private String messageId;
    private Object[] args;
    private String message;

    public FPException(String messageId) {
        this(messageId, EMPTY_ARGS);
    }

    public FPException(String messageId, Object[] args) {
        this(messageId, args, null, null);
    }

    public FPException(String messageId, RowWrapper row) {
        this(messageId, null, row, null);
    }

    public FPException(String messageId, Object[] args, RowWrapper row) {
        this(messageId, args, row, null);
    }

    public FPException(String messageId, Object[] args, Throwable cause) {
        this(messageId, args, null, cause);
    }

    public FPException(String messageId, Object[] args, RowWrapper row, Throwable cause) {
        this.initCause(cause);
        this.messageId = messageId;
        this.args = this.getParam(args, row);
        ResourceBundle bundle = ResourceUtil.getAppExceptionBundle();
        String pattern = bundle.getString(messageId);
        this.message = MessageFormat.format(pattern, this.args);
    }

    private Object[] getParam(Object[] args, RowWrapper row) {
        if (row == null || row.isNullRow()) {
            return args;
        }
        return this.getParamIncludingRowNum(args, row);
    }

    private Object[] getParamIncludingRowNum(Object[] args, RowWrapper row) {
        int rowNum = row.getHSSFRow().getRowNum() + 1;
        int paramLength = args == null ? 1 : args.length + 1;
        Object[] params = new Object[paramLength];
        for (int i = 0; i < paramLength - 1; ++i) {
            params[i] = args[i];
        }
        params[paramLength - 1] = row.getSheet().getSheetName() + " : " + rowNum;
        return params;
    }

    public Object[] getArgs() {
        if (this.args == null) {
            return null;
        }
        return (Object[])this.args.clone();
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getMessage() {
        return this.message;
    }
}

