/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.preview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.fisshplate.wrapper.CellWrapper;
import org.seasar.fisshplate.wrapper.RowWrapper;
import org.seasar.fisshplate.wrapper.SheetWrapper;

public class FPMapData {
    protected String keyName;
    protected SheetWrapper sheet;
    protected List childList = new ArrayList();

    FPMapData(SheetWrapper sheet, String keyName) {
        this.sheet = sheet;
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void addChild(SheetWrapper sheet, String keyName) {
        this.childList.add(new FPMapData(sheet, keyName));
    }

    public FPMapData getChildByKey(String keyName) {
        for (int i = 0; i < this.childList.size(); ++i) {
            FPMapData mapData = (FPMapData)this.childList.get(i);
            if (!mapData.getKeyName().equals(keyName)) continue;
            return mapData;
        }
        return null;
    }

    public Object buildData() {
        if (this.sheet == null) {
            return this.buildMapData();
        }
        if (this.sheet.getRowCount() <= 2) {
            String firstCell = this.sheet.getRow(0).getCell(0).getStringValue();
            if ("empty list".equals(firstCell)) {
                return new ArrayList();
            }
            return this.buildMapData();
        }
        return this.buildListData();
    }

    protected Map buildMapData() {
        HashMap data = new HashMap();
        if (this.sheet != null) {
            RowWrapper keys = this.sheet.getRow(0);
            RowWrapper vals = this.sheet.getRow(1);
            this.putValueToMap(data, keys, vals);
        }
        this.buildChildData(data);
        return data;
    }

    protected List buildListData() {
        RowWrapper keys = this.sheet.getRow(0);
        ArrayList list = new ArrayList();
        for (int i = 1; i < this.sheet.getRowCount(); ++i) {
            HashMap item = new HashMap();
            RowWrapper vals = this.sheet.getRow(i);
            this.putValueToMap(item, keys, vals);
            this.buildChildData(item);
            list.add(item);
        }
        return list;
    }

    protected void buildChildData(Map data) {
        for (int i = 0; i < this.childList.size(); ++i) {
            FPMapData mapData = (FPMapData)this.childList.get(i);
            Object childData = mapData.buildData();
            data.put(mapData.getKeyName(), childData);
        }
    }

    protected void putValueToMap(Map data, RowWrapper keys, RowWrapper vals) {
        for (int i = 0; i < keys.getCellCount(); ++i) {
            CellWrapper key = keys.getCell(i);
            if (key.isNullCell()) continue;
            CellWrapper val = vals.getCell(i);
            String keyStr = key.getStringValue();
            Object valObj = val.getObjectValue();
            data.put(keyStr, valObj);
        }
    }
}

