package tk.eclipse.plugin.jseditor.editors;

import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

/**
 *
 * @author Naoki Takezoe
 */
public class JavaScriptPartitionScanner extends RuleBasedPartitionScanner {

	public final static String JS_COMMENT = "__js_comment";
	public final static String JS_JSDOC = "__js_jsdoc";

	public JavaScriptPartitionScanner(){
		IToken comment = new Token(JS_COMMENT);
		IToken jsdoc = new Token(JS_JSDOC);

		IPredicateRule[] rules = new IPredicateRule[2];
		rules[0] = new MultiLineRule("/**" , "*/" ,jsdoc);
		rules[1] = new MultiLineRule("/*" , "*/" ,comment);

		setPredicateRules(rules);
	}

}
