/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.amateras.mirage.ResultEntityCreator;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.MirageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResultEntityCreator
implements ResultEntityCreator {
    @Override
    public <T> T createEntity(Class<T> clazz, ResultSet rs, ResultSetMetaData meta, int columnCount, BeanDesc beanDesc, Dialect dialect, List<ValueType> valueTypes, NameConverter nameConverter) throws Exception {
        ValueType valueType;
        if (dialect.getValueType() != null && (valueType = dialect.getValueType()).isSupport(clazz)) {
            return (T)valueType.get(clazz, rs, 1);
        }
        for (ValueType valueType2 : valueTypes) {
            if (!valueType2.isSupport(clazz)) continue;
            return (T)valueType2.get(clazz, rs, 1);
        }
        HashMap entity = null;
        if (clazz == Map.class) {
            entity = new HashMap();
        } else {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            entity = constructor.newInstance(new Object[0]);
        }
        for (int i = 0; i < columnCount; ++i) {
            Class<?> fieldType;
            ValueType valueType3;
            String columnName = meta.getColumnName(i + 1);
            String propertyName = nameConverter.columnToProperty(columnName);
            PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
            if (pd == null || (valueType3 = MirageUtil.getValueType(fieldType = pd.getPropertyType(), dialect, valueTypes)) == null) continue;
            pd.setValue(entity, valueType3.get(fieldType, rs, columnName));
        }
        return (T)entity;
    }
}

