/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.session;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.amateras.mirage.SqlManager;
import jp.sf.amateras.mirage.SqlManagerImpl;
import jp.sf.amateras.mirage.exception.SessionException;
import jp.sf.amateras.mirage.provider.DefaultConnectionProvider;
import jp.sf.amateras.mirage.session.DialectAutoSelector;
import jp.sf.amateras.mirage.session.Session;
import jp.sf.amateras.mirage.util.StringUtil;

public class JDBCSessionImpl
implements Session {
    private static final Logger logger = Logger.getLogger(JDBCSessionImpl.class.getName());
    private SqlManager sqlManager;
    private DefaultConnectionProvider provider;
    private String driver;
    private String url;
    private String user;
    private String password;
    private ThreadLocal<Boolean> rollbackOnly = new ThreadLocal();

    public JDBCSessionImpl(Properties properties) {
        this.driver = properties.getProperty("jdbc.driver");
        this.url = properties.getProperty("jdbc.url");
        this.user = properties.getProperty("jdbc.user");
        this.password = properties.getProperty("jdbc.password");
        this.sqlManager = new SqlManagerImpl();
        this.sqlManager.setDialect(DialectAutoSelector.getDialect(this.url));
        this.provider = new DefaultConnectionProvider();
        this.sqlManager.setConnectionProvider(this.provider);
        String cache = properties.getProperty("sql.cache");
        if ("true".equals(cache)) {
            ((SqlManagerImpl)this.sqlManager).setCacheMode(true);
        } else {
            ((SqlManagerImpl)this.sqlManager).setCacheMode(false);
        }
    }

    public void begin() throws SessionException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Begin transaction.");
        }
        try {
            if (StringUtil.isNotEmpty(this.driver)) {
                Class.forName(this.driver);
            }
            Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
            conn.setAutoCommit(false);
            this.provider.setConnection(conn);
        }
        catch (Exception ex) {
            throw new SessionException("Failed to begin transaction.", ex);
        }
    }

    public void commit() throws SessionException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Commit transaction.");
        }
        try {
            this.provider.getConnection().commit();
        }
        catch (Exception ex) {
            throw new SessionException("Failed to commit transaction.", ex);
        }
    }

    public SqlManager getSqlManager() throws SessionException {
        return this.sqlManager;
    }

    public void release() throws SessionException {
        this.rollbackOnly.remove();
        if (this.provider instanceof DefaultConnectionProvider) {
            this.provider.releaseConnection();
        }
    }

    public void rollback() throws SessionException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Rollback transaction.");
        }
        try {
            this.provider.getConnection().rollback();
        }
        catch (Exception ex) {
            throw new SessionException("Failed to rollback transaction.", ex);
        }
    }

    public void setRollbackOnly() {
        this.rollbackOnly.set(true);
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly.get() != null;
    }
}

