/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.amateras.mirage.EntityCreationFailedException;
import jp.sf.amateras.mirage.ResultEntityCreator;
import jp.sf.amateras.mirage.annotation.Column;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.type.ValueType;
import jp.sf.amateras.mirage.util.MirageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResultEntityCreator
implements ResultEntityCreator {
    private static final Logger logger = Logger.getLogger(DefaultResultEntityCreator.class.getName());

    @Override
    public <T> T createEntity(Class<T> clazz, ResultSet rs, ResultSetMetaData meta, int columnCount, BeanDesc beanDesc, Dialect dialect, List<ValueType<?>> valueTypes, NameConverter nameConverter) {
        try {
            ValueType<?> valueType = MirageUtil.getValueType(clazz, dialect, valueTypes);
            if (valueType != null) {
                return (T)valueType.get(clazz, rs, 1);
            }
            HashMap entity = null;
            if (clazz == Map.class) {
                entity = new HashMap();
            } else {
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
                    constructor.setAccessible(true);
                    Class<?>[] types = constructor.getParameterTypes();
                    Object[] params = new Object[types.length];
                    for (int i = 0; i < params.length; ++i) {
                        ValueType<?> valueType2 = MirageUtil.getValueType(types[i], dialect, valueTypes);
                        if (valueType2 == null) continue;
                        params[i] = valueType2.getDefaultValue();
                    }
                    entity = constructor.newInstance(params);
                }
            }
            for (int i = 0; i < columnCount; ++i) {
                String columnName = meta.getColumnName(i + 1);
                PropertyDesc pd = null;
                for (int j = 0; j < beanDesc.getPropertyDescSize(); ++j) {
                    PropertyDesc property = beanDesc.getPropertyDesc(j);
                    Column column = property.getAnnotation(Column.class);
                    if (column == null || !columnName.equalsIgnoreCase(column.name())) continue;
                    pd = property;
                    break;
                }
                if (pd == null) {
                    String propertyName = nameConverter.columnToProperty(columnName);
                    pd = beanDesc.getPropertyDesc(propertyName);
                }
                if (pd != null) {
                    Class<?> propertyType = pd.getPropertyType();
                    ValueType<?> valueType3 = MirageUtil.getValueType(propertyType, dialect, valueTypes);
                    if (valueType3 != null) {
                        pd.setValue(entity, valueType3.get(propertyType, rs, columnName));
                        continue;
                    }
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine(String.format("column [%s] is ignored because property [%s]'s type is not supported: %s", columnName, pd.getPropertyName(), propertyType.getName()));
                    continue;
                }
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer(String.format("column [%s] is ignored because property is not found in the bean", columnName));
            }
            return (T)entity;
        }
        catch (SQLException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (SecurityException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (IllegalArgumentException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (InstantiationException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (IllegalAccessException e) {
            throw new EntityCreationFailedException(e);
        }
        catch (InvocationTargetException e) {
            throw new EntityCreationFailedException(e);
        }
    }
}

