/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.session;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;
import jp.sf.amateras.mirage.SqlManager;
import jp.sf.amateras.mirage.SqlManagerImpl;
import jp.sf.amateras.mirage.exception.ConfigurationException;
import jp.sf.amateras.mirage.exception.SessionException;
import jp.sf.amateras.mirage.provider.DefaultConnectionProvider;
import jp.sf.amateras.mirage.session.DialectAutoSelector;
import jp.sf.amateras.mirage.session.Session;
import jp.sf.amateras.mirage.util.StringUtil;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.commons.pool.impl.StackKeyedObjectPoolFactory;

public class DBCPSessionImpl
implements Session {
    private static final Logger logger = Logger.getLogger(DBCPSessionImpl.class.getName());
    private SqlManager sqlManager;
    private DefaultConnectionProvider provider;
    private DataSource dataSource;
    private ThreadLocal<Boolean> rollbackOnly = new ThreadLocal();

    public DBCPSessionImpl(Properties properties) {
        String driver = properties.getProperty("jdbc.driver");
        String url = properties.getProperty("jdbc.url");
        String user = properties.getProperty("jdbc.user");
        String password = properties.getProperty("jdbc.password");
        int maxActive = 100;
        if (StringUtil.isNotEmpty(properties.getProperty("dbcp.max_active"))) {
            maxActive = Integer.parseInt(properties.getProperty("dbcp.max_active"));
        }
        int minIdle = 10;
        if (StringUtil.isNotEmpty(properties.getProperty("dbcp.min_idle"))) {
            minIdle = Integer.parseInt(properties.getProperty("dbcp.min_idle"));
        }
        int maxWait = 5000;
        if (StringUtil.isNotEmpty(properties.getProperty("dbcp.max_wait"))) {
            maxWait = Integer.parseInt(properties.getProperty("dbcp.max_wait"));
        }
        this.sqlManager = new SqlManagerImpl();
        this.sqlManager.setDialect(DialectAutoSelector.getDialect(url));
        this.provider = new DefaultConnectionProvider();
        this.sqlManager.setConnectionProvider(this.provider);
        String cache = properties.getProperty("sql.cache");
        if ("true".equals(cache)) {
            ((SqlManagerImpl)this.sqlManager).setCacheMode(true);
        } else {
            ((SqlManagerImpl)this.sqlManager).setCacheMode(false);
        }
        try {
            if (StringUtil.isNotEmpty(driver)) {
                Class.forName(driver);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(e);
        }
        GenericObjectPool pool = new GenericObjectPool();
        pool.setMaxActive(maxActive);
        pool.setMinIdle(minIdle);
        pool.setMaxWait((long)maxWait);
        pool.setWhenExhaustedAction((byte)1);
        DriverManagerConnectionFactory factory = new DriverManagerConnectionFactory(url, user, password);
        StackKeyedObjectPoolFactory pstFactory = new StackKeyedObjectPoolFactory(50, 10);
        PoolableConnectionFactory poolFactory = new PoolableConnectionFactory((ConnectionFactory)factory, (ObjectPool)pool, (KeyedObjectPoolFactory)pstFactory, null, false, true);
        this.dataSource = new PoolingDataSource(poolFactory.getPool());
    }

    public void begin() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Begin transaction.");
        }
        try {
            Connection conn = this.dataSource.getConnection();
            conn.setAutoCommit(false);
            this.provider.setConnection(conn);
        }
        catch (SQLException ex) {
            throw new SessionException("Failed to begin transaction.", ex);
        }
    }

    public void commit() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Commit transaction.");
        }
        try {
            this.provider.getConnection().commit();
        }
        catch (SQLException ex) {
            throw new SessionException("Failed to commit transaction.", ex);
        }
    }

    public void rollback() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Rollback transaction.");
        }
        try {
            this.provider.getConnection().rollback();
        }
        catch (SQLException ex) {
            throw new SessionException("Failed to rollback transaction.", ex);
        }
    }

    public void release() {
        this.rollbackOnly.remove();
        if (this.provider instanceof DefaultConnectionProvider) {
            this.provider.releaseConnection();
        }
    }

    public SqlManager getSqlManager() {
        return this.sqlManager;
    }

    public void setRollbackOnly() {
        this.rollbackOnly.set(true);
    }

    public boolean isRollbackOnly() {
        return this.rollbackOnly.get() != null;
    }
}

