/*
 * Decompiled with CFR 0.152.
 */
package tk.jsearch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import tk.jsearch.Javadoc;
import tk.jsearch.JavadocList;

public class JavadocSearch {
    private JavadocList list;

    public JavadocSearch(JavadocList list) {
        this.list = list;
    }

    public Javadoc[] doSearch(String word) throws IOException {
        Vector result = new Vector();
        int i = 0;
        while (i < this.list.count()) {
            File frame = new File(this.list.getJavadoc(i), "allclasses-frame.html");
            BufferedReader in = new BufferedReader(new FileReader(frame));
            String line = null;
            while ((line = in.readLine()) != null) {
                this.parseLine(line, word, result, this.list.getJavadoc(i));
            }
            in.close();
            ++i;
        }
        return result.toArray(new Javadoc[result.size()]);
    }

    private void parseLine(String line, String word, Vector result, String base) {
        int hrefStart = line.indexOf("<A HREF=\"");
        if (hrefStart == -1) {
            return;
        }
        int hrefEnd = line.indexOf("\"", hrefStart + 9);
        String href = line.substring(hrefStart + 9, hrefEnd);
        StringBuffer className = new StringBuffer();
        int i = 0;
        while (i < href.length()) {
            char c = href.charAt(i);
            if (c == '/' || c == '\\') {
                className.append(".");
            } else {
                className.append(c);
            }
            ++i;
        }
        int match = className.toString().indexOf(word);
        if (match == -1) {
            return;
        }
        result.add(new Javadoc(base, href));
    }
}

