/*
 * Decompiled with CFR 0.152.
 */
package tk.jsearch;

import java.io.File;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import tk.jsearch.Javadoc;
import tk.jsearch.JavadocList;
import tk.jsearch.JavadocSearch;
import tk.jsearch.SetupDialog;

public class Main {
    private Shell shell;
    private Display display;
    private Text text;
    private Button button;
    private Button setup;
    private Table table;
    private JavadocList list;
    private OleFrame webFrame;
    private OleControlSite webControlSite;
    private OleAutomation oleAutomation;

    public Main(Display display, Shell shell) {
        this.display = display;
        this.shell = shell;
        this.list = new JavadocList();
        this.list.load();
    }

    public void open() {
        this.shell.setText("Javadoc Search");
        this.shell.setLayout((Layout)new FillLayout());
        Composite all = new Composite((Composite)this.shell, 0);
        all.setLayout((Layout)new GridLayout());
        Composite top = new Composite(all, 0);
        top.setLayoutData((Object)new GridData(768));
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 4;
        top.setLayout((Layout)topLayout);
        Label label = new Label(top, 0);
        label.setText("\u30af\u30e9\u30b9\u540d\uff1a");
        this.text = new Text(top, 2048);
        this.text.setLayoutData((Object)new GridData(768));
        this.button = new Button(top, 0);
        this.button.setText(" \u691c \u7d22 ");
        this.button.addSelectionListener((SelectionListener)new SearchListener());
        this.setup = new Button(top, 0);
        this.setup.setText(" \u8a2d \u5b9a ");
        this.setup.addSelectionListener((SelectionListener)new SetupListener());
        SashForm sash = new SashForm(all, 512);
        sash.setLayoutData((Object)new GridData(1808));
        this.table = new Table((Composite)sash, 67586);
        this.table.setHeaderVisible(true);
        String[] cols = new String[]{"\u30af\u30e9\u30b9\u540d", "\u5834\u6240"};
        int i = 0;
        while (i < cols.length) {
            TableColumn col = new TableColumn(this.table, 16384);
            col.setText(cols[i]);
            col.setWidth(180);
            ++i;
        }
        this.table.addSelectionListener((SelectionListener)new NavigateListener());
        this.webFrame = new OleFrame((Composite)sash, 0);
        this.webControlSite = new OleControlSite((Composite)this.webFrame, 0, "Shell.Explorer");
        this.oleAutomation = new OleAutomation((OleClientSite)this.webControlSite);
        boolean activated = this.webControlSite.doVerb(-5) == 0;
        String docPath = new File("./doc/index.html").getAbsolutePath();
        String url = "file:" + docPath;
        int[] rgdispid = this.oleAutomation.getIDsOfNames(new String[]{"Navigate", "URL"});
        int dispIdMember = rgdispid[0];
        Variant[] rgvarg = new Variant[]{new Variant(url)};
        int[] rgdispidNamedArgs = new int[]{rgdispid[1]};
        Variant pVarResult = this.oleAutomation.invoke(dispIdMember, rgvarg, rgdispidNamedArgs);
        this.shell.setSize(400, 400);
        this.shell.open();
    }

    public static void main(String[] args) throws Exception {
        Display display = new Display();
        Shell shell = new Shell(display);
        Main main = new Main(display, shell);
        main.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
        System.exit(0);
    }

    class SetupListener
    extends SelectionAdapter {
        SetupListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            SetupDialog dialog = new SetupDialog(Main.this.shell, Main.this.list);
            dialog.open();
        }
    }

    class NavigateListener
    extends SelectionAdapter {
        NavigateListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            int index = Main.this.table.getSelectionIndex();
            if (index == -1) {
                return;
            }
            String url = "file:" + Main.this.table.getItem(index).getText(1);
            int[] rgdispid = Main.this.oleAutomation.getIDsOfNames(new String[]{"Navigate", "URL"});
            int dispIdMember = rgdispid[0];
            Variant[] rgvarg = new Variant[]{new Variant(url)};
            int[] rgdispidNamedArgs = new int[]{rgdispid[1]};
            Variant pVarResult = Main.this.oleAutomation.invoke(dispIdMember, rgvarg, rgdispidNamedArgs);
        }
    }

    class SearchListener
    extends SelectionAdapter {
        SearchListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String word = Main.this.text.getText();
            if (word.equals("")) {
                return;
            }
            JavadocSearch search = new JavadocSearch(Main.this.list);
            try {
                Javadoc[] result = search.doSearch(word);
                if (result.length == 0) {
                    MessageBox msg = new MessageBox(Main.this.shell, 8);
                    msg.setText("\u691c\u7d22\u7d50\u679c");
                    msg.setMessage("\u8a72\u5f53\u3059\u308b\u30af\u30e9\u30b9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
                    msg.open();
                    return;
                }
                Main.this.table.removeAll();
                int i = 0;
                while (i < result.length) {
                    TableItem item = new TableItem(Main.this.table, 0);
                    String[] data = new String[]{result[i].getClassName(), result[i].getLocation()};
                    item.setText(data);
                    ++i;
                }
            }
            catch (Exception ex) {
                MessageBox msg = new MessageBox(Main.this.shell, 1);
                msg.setText("\u4f8b\u5916");
                msg.setMessage(ex.toString());
                msg.open();
                ex.printStackTrace();
            }
        }
    }
}

