package tk.jsearch;

import java.io.*;

public class Javadoc {
	
	private String baseDir;
	private String path;
	
	public Javadoc(String baseDir,String path){
		setBaseDir(baseDir);
		setPath(path);
	}
	
	public void setBaseDir(String baseDir){
		this.baseDir = baseDir;
	}
	
	public String getBaseDir(){
		return this.baseDir;
	}
	
	public void setPath(String path){
		this.path = path;
	}
	
	public String getPath(){
		return this.path;
	}
	
	public String getClassName(){
		StringBuffer sb = new StringBuffer();
		String className = path.substring(0,path.length()-5);
		for(int i=0;i<className.length();i++){
			char c = path.charAt(i);
			if(c=='/' || c=='\\'){
				sb.append(".");
			} else {
				sb.append(c);
			}
		}
		return sb.toString();
	}
	
	public String getLocation(){
		File file = new File(baseDir,path);
		return file.getAbsolutePath();
	}
}