package tk.jsearch;

import java.io.*;
import java.util.*;

/**
 * JavadocT[`NX
 */
public class JavadocSearch {
	
	private JavadocList list;
	
	/**
	 * RXgN^
	 */
	public JavadocSearch(JavadocList list){
		this.list = list;
	}
	
	/**
	 * s܂B
	 */
	public Javadoc[] doSearch(String word) throws IOException {
		Vector result = new Vector();
		for(int i=0;i<list.count();i++){
			File frame = new File(list.getJavadoc(i),"allclasses-frame.html");
			BufferedReader in = new BufferedReader(new FileReader(frame));
			String line = null;
			while((line=in.readLine())!=null){
				parseLine(line,word,result,list.getJavadoc(i));
			}
			in.close();
		}
		return (Javadoc[])result.toArray(new Javadoc[result.size()]);
	}
	
	/**
	 * Ps
	 */
	private void parseLine(String line,String word,Vector result,String base){
		
		int hrefStart = line.indexOf("<A HREF=\"");
		if(hrefStart==-1){ return; }
		int hrefEnd = line.indexOf("\"",hrefStart+9);
		String href = line.substring(hrefStart+9,hrefEnd);
		
		StringBuffer className = new StringBuffer();
		for(int i=0;i<href.length();i++){
			char c = href.charAt(i);
			if(c=='/' || c=='\\'){
				className.append(".");
			} else {
				className.append(c);
			}
		}
		
		int match = className.toString().indexOf(word);
		if(match==-1){ return; }
		
		
//		int classStart = line.indexOf(">",hrefEnd);
//		int classEnd   = line.indexOf("<".classStart+1);
//		String className = line.substring(classStart+1,classEnd);
		
		result.add(new Javadoc(base,href));
	}

}