package tk.jsearch;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.custom.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.ole.win32.*;
import java.io.*;

/**
 * NpNX
 */
public class Main {
	
	private Shell shell;
	private Display display;
	private Text text;
	private Button button;
	private Button setup;
	private Table table;
	
	private JavadocList list;
	
	private OleFrame webFrame;
	private OleControlSite webControlSite;
	private OleAutomation oleAutomation;
	
	public Main(Display display,Shell shell){
		this.display = display;
		this.shell = shell;
		
		this.list = new JavadocList();
		this.list.load();
		//list.addJavadoc("D:/apps/docs/ja/api");
	}
	
	public void open(){
		
		shell.setText("Javadoc Search");
		shell.setLayout(new FillLayout());
		
		Composite all = new Composite(shell,SWT.NULL);
		all.setLayout(new GridLayout());
		
		Composite top = new Composite(all,SWT.NULL);
		top.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		//top.addKeyListener(new TestKeyListener());
		
		///////////////////////////////////////////////////
		// tH[
		GridLayout topLayout = new GridLayout();
		topLayout.numColumns = 4;
		top.setLayout(topLayout);
		
		Label label = new Label(top,SWT.NULL);
		label.setText("NXF");
		
		text = new Text(top,SWT.BORDER);
		text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		button = new Button(top,SWT.NULL);
		button.setText("   ");
		button.addSelectionListener(new SearchListener());
		
		setup = new Button(top,SWT.NULL);
		setup.setText("   ");
		setup.addSelectionListener(new SetupListener());
		
		///////////////////////////////////////////////////
		//
		SashForm sash = new SashForm(all,SWT.VERTICAL);
		sash.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		table = new Table(sash,SWT.MULTI|SWT.FULL_SELECTION|SWT.BORDER);
		table.setHeaderVisible(true);
		String[] cols = {"NX","ꏊ"};
		for(int i=0;i<cols.length;i++){
			TableColumn col = new TableColumn(table,SWT.LEFT);
			col.setText(cols[i]);
			col.setWidth(180);
		}
		table.addSelectionListener(new NavigateListener());
		
		webFrame = new OleFrame(sash,SWT.NONE);
		webControlSite = new OleControlSite(webFrame,SWT.NONE,"Shell.Explorer");
		oleAutomation = new OleAutomation(webControlSite);
		
		boolean activated = (webControlSite.doVerb(OLE.OLEIVERB_INPLACEACTIVATE)==OLE.S_OK);
		
		// y[W\
		String docPath = new File("./doc/index.html").getAbsolutePath();
		String url = "file:"+docPath;
		int[] rgdispid = oleAutomation.getIDsOfNames(new String[]{"Navigate","URL"});
		int dispIdMember = rgdispid[0];
		Variant[] rgvarg = new Variant[1];
		rgvarg[0] = new Variant(url);
		int[] rgdispidNamedArgs = new int[1];
		rgdispidNamedArgs[0] = rgdispid[1];
		Variant pVarResult = oleAutomation.invoke(dispIdMember,rgvarg,rgdispidNamedArgs);
		
		// EBhE\
		shell.setSize(400,400);
		shell.open();
	}
	
	public static void main(String[] args) throws Exception {
		Display display = new Display();
		Shell shell = new Shell(display);
		Main main = new Main(display,shell);
		main.open();
		while (!shell.isDisposed ()){
			if (!display.readAndDispatch ()){
				display.sleep ();
			}
		}
		display.dispose();
		System.exit(0);
	}
	
	/**
	 * {^
	 */
	class SearchListener extends SelectionAdapter {
		
		public void widgetSelected(SelectionEvent e){
			String word = text.getText();
			if(word.equals("")){ return; }
			
			JavadocSearch search = new JavadocSearch(list);
			try {
				Javadoc[] result = search.doSearch(word);
				if(result.length==0){
					MessageBox msg = new MessageBox(shell,SWT.ICON_WARNING);
					msg.setText("");
					msg.setMessage("YNX݂͑܂B");
					msg.open();
					return;
				}
				
				table.removeAll();
				for(int i=0;i<result.length;i++){
					TableItem item = new TableItem(table,SWT.NULL);
					String[] data = {result[i].getClassName(),result[i].getLocation()};
					item.setText(data);
				}
			} catch(Exception ex){
				MessageBox msg = new MessageBox(shell,SWT.ICON_ERROR);
				msg.setText("O");
				msg.setMessage(ex.toString());
				msg.open();
				ex.printStackTrace();
			}
		}
	}
	
	/**
	 * uEU
	 */
	class NavigateListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e){
			int index = table.getSelectionIndex();
			if(index==-1){ return; }
			
			String url = "file:" + table.getItem(index).getText(1);
			
			int[] rgdispid = oleAutomation.getIDsOfNames(new String[]{"Navigate","URL"});
			int dispIdMember = rgdispid[0];
			Variant[] rgvarg = new Variant[1];
			rgvarg[0] = new Variant(url);
			int[] rgdispidNamedArgs = new int[1];
			rgdispidNamedArgs[0] = rgdispid[1];
			Variant pVarResult = oleAutomation.invoke(dispIdMember,rgvarg,rgdispidNamedArgs);
			
		}
	}

	/**
	 * ݒ
	 */
	class SetupListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e){
			SetupDialog dialog = new SetupDialog(shell,list);
			dialog.open();
		}
	}
	
	/**
	 * eXgp
	 */
	/*
	class TestKeyListener extends KeyAdapter {
		public void keyPressed(KeyEvent e){
			System.out.println(e.toString());
		}
	}
	*/
}