package tk.jsearch;

import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;

public class SetupDialog {
	
	private Shell shell;
	private Display display;
	private List list;
	//private Text text;
	private Button add;
	private Button remove;
	private Button ok;
	private Button cancel;
	
	private JavadocList javadoc;
	
	public SetupDialog(Shell shell,JavadocList javadoc){
		this.shell = new Shell(shell,SWT.TITLE|SWT.MIN|SWT.CLOSE|SWT.APPLICATION_MODAL|SWT.RESIZE);
		this.javadoc = javadoc;
		initComponents();
	}

	private void initComponents(){
		shell.setText("ݒ");
		shell.setLayout(new GridLayout());
		
		Group edit = new Group(shell,SWT.SHADOW_ETCHED_IN );
		edit.setText(" Ώۂ javadoc ");
		edit.setLayout(new GridLayout());
		edit.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		Composite buttons = new Composite(edit,SWT.NULL);
		buttons.setLayout(new RowLayout(SWT.HORIZONTAL));
		add = new Button(buttons,SWT.NULL);
		add.setText("   ");
		add.addSelectionListener(new AddListener());
		remove = new Button(buttons,SWT.NULL);
		remove.setText("   ");
		remove.addSelectionListener(new RemoveListener());
		
		list = new List(edit,SWT.SINGLE|SWT.BORDER|SWT.V_SCROLL);
		list.setLayoutData(new GridData(GridData.FILL_BOTH));
		for(int i=0;i<javadoc.count();i++){
			list.add(javadoc.getJavadoc(i));
		}
		
		Composite comp = new Composite(shell,SWT.NULL);
		comp.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
		comp.setLayout(new RowLayout(SWT.HORIZONTAL));
		
		ok = new Button(comp,SWT.NULL);
		ok.setText("    nj    ");
		ok.addSelectionListener(new OKListener());
		cancel = new Button(comp,SWT.NULL);
		cancel.setText(" LZ ");
		cancel.addSelectionListener(new CancelListener());
		
		shell.setSize(300,200);
	}
	
	public void open(){
		Display display = this.shell.getDisplay();
		this.shell.open();
		
		// ubN
		while (!this.shell.isDisposed ()){
			if (!display.readAndDispatch ()){
				display.sleep ();
			}
		}
	}

	class AddListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e){
			DirectoryDialog dialog = new DirectoryDialog(shell);
			dialog.setMessage("ǉ javadoc IĂ");
			String path = dialog.open();
			if(path!=null){
				list.add(path);
			}
		}
	}
	
	class RemoveListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e){
			int index = list.getSelectionIndex();
			if(index==-1){ return; }
			list.remove(index);
		}
	}
	
	class OKListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e){
			javadoc.removeAll();
			String[] items = list.getItems();
			for(int i=0;i<items.length;i++){
				javadoc.addJavadoc(items[i]);
			}
			javadoc.save();
			shell.dispose();
		}
	}
	
	class CancelListener extends SelectionAdapter {
		public void widgetSelected(SelectionEvent e){
			shell.dispose();
		}
	}
	
}